/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core.persistqueue;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.ISchedulerQueue;
import noticecast.scheduling.core.SchedulerQueueException;
import noticecast.scheduling.core.persistqueue.PersistableSchedulerQueueEntry;
import noticecast.scheduling.nc.NCSchedulableId;

public class PersistableSchedulerQueue
implements ISchedulerQueue {
    private static ISchedulerQueue m_instance = new PersistableSchedulerQueue();
    private final String m_TABLE_NAME = "NC_SCHEDULE_QUEUE";
    private final String m_SCHEDULE_ID_COLUMN = "SCHEDULE_ID";
    private final String m_SCHEDULE_ID_COLUMN_qualified = "NC_SCHEDULE_QUEUE.SCHEDULE_ID";
    private final String m_RUN_DATE_COLUMN = "RUN_DATE";
    private final String m_RUN_DATE_COLUMN_qualified = "NC_SCHEDULE_QUEUE.RUN_DATE";
    private final String m_TENANTID_COLUMN = "TENANT_ID";
    private final String m_ADD_STATEMENT = new StringBuffer("INSERT INTO ").append("NC_SCHEDULE_QUEUE").append(" (").append("SCHEDULE_ID").append(", ").append("RUN_DATE").append(") values (?, ?)").toString();
    private final String m_DELETE_STATEMENT = new StringBuffer("DELETE FROM ").append("NC_SCHEDULE_QUEUE").append(" WHERE ").append("SCHEDULE_ID").append(" = ?").toString();
    private final String m_DELETE_STATEMENT_WITH_DATE = new StringBuffer("DELETE FROM ").append("NC_SCHEDULE_QUEUE").append(" WHERE ").append("SCHEDULE_ID").append(" = ? AND ").append("RUN_DATE").append(" = ? ").toString();
    private final String m_DELETE_ALL_STATEMENT = new StringBuffer("DELETE FROM ").append("NC_SCHEDULE_QUEUE").toString();
    private final String m_GET_FIRST_ITEM = new StringBuffer("SELECT ").append("SCHEDULE_ID").append(", ").append("RUN_DATE").append(" FROM ").append("NC_SCHEDULE_QUEUE").append(" WHERE ").append("RUN_DATE").append(" <= ? ").toString();
    private final String m_NEXT_ENTRY_WAIT_TIME = new StringBuffer("SELECT ").append("SCHEDULE_ID").append(", ").append("RUN_DATE").append(" FROM ").append("NC_SCHEDULE_QUEUE").append(" ORDER BY ").append("RUN_DATE").toString();
    private final String m_GET_CONTENTS = new StringBuffer("SELECT ").append("SCHEDULE_ID").append(", ").append("RUN_DATE").append(" FROM ").append("NC_SCHEDULE_QUEUE").toString();
    private final String m_GET_CONTENTS_TO_END_DATE = "SELECT " + "SCHEDULE_ID" + ", " + "RUN_DATE" + " FROM " + "NC_SCHEDULE_QUEUE" + " WHERE " + "RUN_DATE" + " <= ? ";
    private final String m_GET_CONTENTS_TO_END_DATE_tenant_filtered = "SELECT " + "NC_SCHEDULE_QUEUE.SCHEDULE_ID" + ", " + "NC_SCHEDULE_QUEUE.RUN_DATE" + " FROM " + "NC_SCHEDULE_QUEUE, NC_TASKSCHEDULE" + " WHERE " + "NC_SCHEDULE_QUEUE.SCHEDULE_ID = NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID" + " AND " + "NC_SCHEDULE_QUEUE.RUN_DATE" + " <= ?" + " AND (NC_TASKSCHEDULE.TENANT_ID = ''";
    private Map m_transactionConnections = new HashMap();
    private Long m_pollInterval;

    public static ISchedulerQueue instance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean addToQueue(IQueueEntry entry) {
        boolean result = false;
        JDBCConnection conn = null;
        try {
            conn = this.getConnection();
            result = this.doAdd((Connection)conn, entry);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_INSERT_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
            this.checkTransactionError();
        }
        finally {
            this.releaseConnection(conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IQueueEntry getFirstEntry() {
        IQueueEntry queue_entry = null;
        JDBCConnection conn = null;
        try {
            conn = this.getConnection();
            queue_entry = this.doGetFirstEntry((Connection)conn);
            if (null == queue_entry) {
                queue_entry = this.getNextEntryWaitTime((Connection)conn);
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
            this.checkTransactionError();
        }
        finally {
            this.releaseConnection(conn);
        }
        return queue_entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(IQueueEntry to_remove) {
        boolean success = false;
        JDBCConnection conn = null;
        try {
            conn = this.getConnection();
            success = this.doRemove((Connection)conn, to_remove);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_DELETE_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
            this.checkTransactionError();
        }
        finally {
            this.releaseConnection(conn);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized boolean removeAll() {
        boolean success = true;
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        conn = this.getConnection();
        ps = conn.prepareStatement(this.m_DELETE_ALL_STATEMENT);
        int n = ps.executeUpdate();
        try {
            SqlResourceCloser.closeResources(null, (Statement)ps);
        }
        finally {
            this.releaseConnection(conn);
        }
        catch (SQLException ex) {
            try {
                success = false;
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(null, ps);
                }
                finally {
                    this.releaseConnection(conn);
                }
                throw throwable;
            }
            try {
                SqlResourceCloser.closeResources(null, (Statement)ps);
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Collection schedulerQueueContents() throws SchedulerQueueException {
        List entriesList = null;
        JDBCConnection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.m_GET_CONTENTS);
            entriesList = this.readEntries(rs);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
                this.checkTransactionError();
                throw new SchedulerQueueException(I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{""});
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(rs, (Statement)stmt);
                    throw throwable;
                }
                finally {
                    this.releaseConnection(conn);
                }
            }
        }
        try {
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)stmt);
            return entriesList;
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Collection schedulerQueueContents(Date endDate) throws SchedulerQueueException {
        List entriesList = null;
        JDBCConnection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(this.m_GET_CONTENTS_TO_END_DATE);
            ps.setLong(1, endDate.getTime());
            rs = ps.executeQuery();
            entriesList = this.readEntries(rs);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
                this.checkTransactionError();
                throw new SchedulerQueueException(I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{""});
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(rs, ps);
                    throw throwable;
                }
                finally {
                    this.releaseConnection(connection);
                }
            }
        }
        try {
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
            return entriesList;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Collection schedulerQueueContents(String[] tenantIDs, Date endDate) throws SchedulerQueueException {
        List entriesList = null;
        JDBCConnection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = this.prepareQueueQuery(connection, tenantIDs, endDate);
            rs = ps.executeQuery();
            entriesList = this.readEntries(rs);
        }
        catch (SQLException ex) {
            try {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
                this.checkTransactionError();
                throw new SchedulerQueueException(I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{""});
            }
            catch (Throwable throwable) {
                try {
                    SqlResourceCloser.closeResources(rs, ps);
                    throw throwable;
                }
                finally {
                    this.releaseConnection(connection);
                }
            }
        }
        try {
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
            return entriesList;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    protected PreparedStatement prepareQueueQuery(JDBCConnection connection, String[] tenantIDs, Date endDate) throws SQLException {
        StringBuffer sql = new StringBuffer(this.m_GET_CONTENTS_TO_END_DATE_tenant_filtered);
        if (tenantIDs != null && tenantIDs.length > 0) {
            sql.append(" OR NC_TASKSCHEDULE.TENANT_ID IN (");
            for (int i = 0; i < tenantIDs.length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append('?');
            }
            sql.append(")");
        }
        sql.append(")");
        PreparedStatement ps = connection.prepareStatement(sql.toString());
        ps.setLong(1, endDate.getTime());
        if (tenantIDs != null && tenantIDs.length > 0) {
            for (int i = 0; i < tenantIDs.length; ++i) {
                ps.setString(i + 2, tenantIDs[i]);
            }
        }
        return ps;
    }

    @Override
    public synchronized void beginTransaction() throws SchedulerQueueException {
        AuditProperties ap;
        if (this.m_transactionConnections.size() > 0) {
            String s = "Error: " + this.m_transactionConnections.size() + " transaction(s) in progress when begin transaction called(violates single threaded model)";
            ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_BEGIN_TRANSACTION_ERROR, (Object[])new String[]{s}, (Map)ap);
        }
        try {
            Thread currentThread = Thread.currentThread();
            TransactionConnection connection = new TransactionConnection();
            this.m_transactionConnections.put(currentThread, connection);
        }
        catch (SQLException ex) {
            ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""}, (Map)ap);
            throw new SchedulerQueueException(I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, new Object[]{ex.getMessage()});
        }
    }

    @Override
    public synchronized void endTransaction() throws SchedulerQueueException {
        try {
            Thread currentThread = Thread.currentThread();
            Object tcObj = this.m_transactionConnections.remove(currentThread);
            if (tcObj == null) {
                throw new SchedulerQueueException(I18NCode.SQL_UNEND_TRANS_ERROR);
            }
            ((TransactionConnection)tcObj).endTransaction();
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
            throw new SchedulerQueueException(I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, new Object[]{ex.getMessage()});
        }
    }

    @Override
    public Long getPollInterval() {
        return this.m_pollInterval;
    }

    @Override
    public void setPollInterval(Long pollInterval) {
        this.m_pollInterval = pollInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAdd(Connection connection, IQueueEntry entry) throws SQLException {
        if (entry == null) {
            return false;
        }
        boolean result = false;
        ISchedulableId schId = null;
        PreparedStatement ps = null;
        try {
            schId = entry.getSchedulableId();
            if (schId == null) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_NO_ID);
                throw new SQLException(I18NUtil.getMessage((I18NCode)I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_NO_ID, (Locale)SDSLogger.getLocale()));
            }
            String idString = schId.toString().trim();
            long idlong = Long.valueOf(idString);
            ps = connection.prepareStatement(this.m_ADD_STATEMENT);
            ps.setLong(1, idlong);
            ps.setLong(2, entry.getDate().getTime());
            int rows = ps.executeUpdate();
            if (rows < 1) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_NOT_ADDED_ERROR, (Object[])new String[]{"rows < 1 - ID: " + idlong});
            }
            result = rows == 1;
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueueEntry doGetFirstEntry(Connection connection) throws SQLException {
        IQueueEntry result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"PersistableScheduleQueue.doGetFirstEntry");
        try {
            ps = connection.prepareStatement(this.m_GET_FIRST_ITEM);
            ps.setMaxRows(1);
            long now = new Date().getTime();
            ps.setLong(1, now);
            rs = ps.executeQuery();
            result = this.readFirstEntry(rs);
        }
        catch (Throwable throwable) {
            SqlResourceCloser.closeResources(rs, (Statement)ps);
            zipiTimer.stop();
            throw throwable;
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)ps);
        zipiTimer.stop();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueueEntry getNextEntryWaitTime(Connection conn) throws SQLException {
        IQueueEntry result = null;
        Statement stmt = null;
        ResultSet rs = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"PersistableScheduleQueue.getNextEntryWaitTime");
        try {
            stmt = conn.createStatement();
            stmt.setMaxRows(1);
            rs = stmt.executeQuery(this.m_NEXT_ENTRY_WAIT_TIME);
            result = this.readFirstEntry(rs);
        }
        finally {
            this.closeStatement(stmt);
            zipiTimer.stop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemove(Connection connection, IQueueEntry entry) throws SQLException {
        boolean useDate = entry.getDate() != null;
        boolean success = false;
        PreparedStatement ps = null;
        try {
            int result;
            ps = useDate ? connection.prepareStatement(this.m_DELETE_STATEMENT_WITH_DATE) : connection.prepareStatement(this.m_DELETE_STATEMENT);
            ISchedulableId schId = entry.getSchedulableId();
            if (schId == null) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_NO_ID);
                throw new SQLException(I18NUtil.getMessage((I18NCode)I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_NO_ID, (Locale)SDSLogger.getLocale()));
            }
            String idString = schId.toString().trim();
            long idlong = Long.valueOf(idString);
            ps.setLong(1, idlong);
            if (useDate) {
                ps.setLong(2, entry.getDate().getTime());
            }
            success = (result = ps.executeUpdate()) == 1;
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        return success;
    }

    private List readEntries(ResultSet result_set) throws SQLException {
        ArrayList<PersistableSchedulerQueueEntry> entriesList = new ArrayList<PersistableSchedulerQueueEntry>();
        while (result_set.next()) {
            NCObjectId ncObjectId = NCObjectIdUtil.instance().createObjectId(result_set, 1);
            NCSchedulableId id = new NCSchedulableId(ncObjectId);
            long dateLong = result_set.getLong(2);
            Date date = new Date(dateLong);
            entriesList.add(new PersistableSchedulerQueueEntry(id, date));
        }
        return entriesList;
    }

    private IQueueEntry readFirstEntry(ResultSet result_set) throws SQLException {
        PersistableSchedulerQueueEntry queue_entry = null;
        if (result_set.next()) {
            NCObjectId ncObjectId = NCObjectIdUtil.instance().createObjectId(result_set, 1);
            NCSchedulableId id = new NCSchedulableId(ncObjectId);
            long dateLong = result_set.getLong(2);
            Date date = new Date(dateLong);
            queue_entry = new PersistableSchedulerQueueEntry(id, date);
        }
        return queue_entry;
    }

    private JDBCConnection getConnection() throws SQLException {
        Object tcObj = this.m_transactionConnections.get(Thread.currentThread());
        if (tcObj == null) {
            return NCConnection.instance().getConnectionFactory().createConnection();
        }
        return ((TransactionConnection)tcObj).getTransactionConnection();
    }

    private void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_CLOSE_SQL_ERROR, (Object[])new String[]{ex.getMessage() + ""});
        }
    }

    private void checkTransactionError() {
        Thread currentThread = Thread.currentThread();
        Object tcObj = this.m_transactionConnections.get(currentThread);
        if (tcObj != null) {
            ((TransactionConnection)tcObj).transactionError();
        }
    }

    private void releaseConnection(JDBCConnection conn) {
        Thread currentThread = Thread.currentThread();
        Object tcObj = this.m_transactionConnections.get(currentThread);
        if (tcObj == null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)conn);
        }
    }

    private class TransactionConnection {
        private JDBCConnection m_transactionConnection;
        private boolean m_transactionError;

        public TransactionConnection() throws SQLException {
            this.m_transactionConnection = PersistableSchedulerQueue.this.getConnection();
            this.m_transactionConnection.setAutoCommit(false);
        }

        public void transactionError() {
            this.m_transactionError = true;
        }

        public JDBCConnection getTransactionConnection() {
            return this.m_transactionConnection;
        }

        public void endTransaction() throws SQLException {
            try {
                if (this.m_transactionError) {
                    this.m_transactionConnection.rollback();
                } else {
                    this.m_transactionConnection.commit();
                }
            }
            finally {
                try {
                    this.m_transactionConnection.setAutoCommit(true);
                }
                finally {
                    SqlResourceCloser.releaseConnection((JDBCConnection)this.m_transactionConnection);
                    this.m_transactionConnection = null;
                }
            }
        }
    }
}

