/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.core.persistqueue;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.INCObjectIdString;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.core.DatatierRecovery;
import java.util.Date;
import noticecast.logictier.NCObjectType;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NCSchedulable;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.services.RepositoryServicesImpl;

public class PersistableSchedulerQueueEntry
implements IQueueEntry {
    private Date m_run_date;
    private ISchedulableId m_schedulable_id;
    private ISchedulable m_schedulable;

    public PersistableSchedulerQueueEntry(ISchedulableId schedule_id, Date run_date) {
        this.m_schedulable_id = schedule_id;
        this.m_run_date = run_date;
    }

    @Override
    public Date getDate() {
        return this.m_run_date;
    }

    @Override
    public void setDate(Date date) {
        this.m_run_date = date;
    }

    @Override
    public ISchedulable getSchedulable() {
        if (this.m_schedulable != null) {
            return this.m_schedulable;
        }
        IPersistManager persist_manager = RepositoryServicesImpl.instance().getPersistManager();
        NCObjectId nc_object_id = NCObjectIdUtil.instance().createObjectId(new INCObjectIdString(){

            public String getNCObjectIdString() {
                return PersistableSchedulerQueueEntry.this.getSchedulableId().toString();
            }
        });
        try {
            ITaskSchedule taskSchedule = (ITaskSchedule)persist_manager.findNCObjectConsumerCopyByOid(nc_object_id, NCObjectType.TASK_SCHEDULE);
            ScheduleLink[] links = taskSchedule.getScheduleLinks();
            if (taskSchedule != null && links != null && links.length > 0) {
                this.m_schedulable = new NCSchedulable(taskSchedule);
            } else {
                DatatierRecovery.instance().repairTaskScheduleAndTask(nc_object_id);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_TASK_NOT_FOUND, (Object[])new String[]{"taskSchedule == null - id: " + nc_object_id.toString()});
            }
        }
        catch (PersistManagerException pme) {
            String s = "id: " + nc_object_id.toString() + " " + pme.getMessage();
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)pme);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_ENTRY_TASK_NOT_FOUND, (Object[])new String[]{s});
            DatatierRecovery.instance().repairTaskScheduleAndTask(nc_object_id);
        }
        return this.m_schedulable;
    }

    @Override
    public ISchedulableId getSchedulableId() {
        return this.m_schedulable_id;
    }

    public int compareTo(Object to_compare) {
        PersistableSchedulerQueueEntry that = (PersistableSchedulerQueueEntry)to_compare;
        return this.getDate().compareTo(that.getDate()) == 0 ? this.getSchedulableId().compareTo(that.getSchedulableId()) : this.getDate().compareTo(that.getDate());
    }
}

