/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.nc;

import com.cognos.sds.event.Event;
import java.util.Date;
import noticecast.runtime.RunTimeManager;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NCSchedulableId;

public class NCSchedulable
implements ISchedulable {
    static final long serialVersionUID = 70009003L;
    private ITaskSchedule m_taskSchedule;

    public NCSchedulable(ITaskSchedule taskSchedule) {
        this.m_taskSchedule = taskSchedule;
    }

    @Override
    public Date getNextExecution() {
        return this.m_taskSchedule.getNextExecution();
    }

    @Override
    public Event getNextExecute(Date date) {
        Event event = this.m_taskSchedule.getNextExecute(date);
        this.addThis(event);
        return event;
    }

    @Override
    public Event getNextExecuteInclusive(Date date) {
        Event event = this.m_taskSchedule.getNextExecuteInclusive(date);
        this.addThis(event);
        return event;
    }

    private void addThis(Event event) {
        if (event != null) {
            event.setSchedulable(this);
        }
    }

    @Override
    public void runTask() {
        this.m_taskSchedule.runTask(RunTimeManager.getInstance());
    }

    @Override
    public ISchedulableId getId() {
        return new NCSchedulableId(this.m_taskSchedule.getNCObjectId());
    }

    public ITaskSchedule getTaskSchedule() {
        return this.m_taskSchedule;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof NCSchedulable) {
            ITaskSchedule otherTaskSchedule = ((NCSchedulable)object).getTaskSchedule();
            isEqual = this.m_taskSchedule.equals(otherTaskSchedule);
        }
        return isEqual;
    }

    public int hashCode() {
        return this.m_taskSchedule.hashCode();
    }
}

