/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.nc;

import java.io.Serializable;
import noticecast.datatier.MiscUtil;

public class ScheduleDelay
implements Serializable {
    static final long serialVersionUID = 70009003L;
    public static final String _classId = "$Id: ScheduleDelay.java,v 1.1 1999/11/17 13:19:00 tonym Exp $";
    private int m_days;
    private int m_hours;
    private int m_minutes;
    private int m_seconds;
    private long m_delay;

    public ScheduleDelay(int days, int hours, int minutes, int seconds) {
        this.m_days = days;
        this.m_hours = hours;
        this.m_minutes = minutes;
        this.m_seconds = seconds;
        this.setDelay();
    }

    private void setDelay() {
        this.m_delay = (long)this.m_days * 86400000L;
        this.m_delay += (long)this.m_hours * 3600000L;
        this.m_delay += (long)this.m_minutes * 60000L;
        this.m_delay += (long)this.m_seconds * 1000L;
    }

    public int getDaysDelay() {
        return this.m_days;
    }

    public int getHoursDelay() {
        return this.m_hours;
    }

    public int getMinutesDelay() {
        return this.m_minutes;
    }

    public int getSecondsDelay() {
        return this.m_seconds;
    }

    public long getDelay() {
        return this.m_delay;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.m_days) + ":" + String.valueOf(this.m_hours) + ":" + String.valueOf(this.m_minutes) + ":" + String.valueOf(this.m_seconds) + ":");
        return buffer.toString();
    }

    public static final synchronized ScheduleDelay recreate(String scheduleDelayString) {
        if (null == scheduleDelayString) {
            return null;
        }
        String[] tokens = MiscUtil.getTokens(scheduleDelayString, ":");
        ScheduleDelay scheduleDelay = new ScheduleDelay(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]));
        return scheduleDelay;
    }

    public static void main(String[] agrs) {
        ScheduleDelay testScheduleDelay = new ScheduleDelay(1, 12, 0, 0);
        String testString = testScheduleDelay.toString();
        System.out.println("testString is: " + testString);
        ScheduleDelay newScheduleDelay = ScheduleDelay.recreate(testString);
        System.out.println("newString is: " + testString);
    }
}

