/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.nc;

import com.cognos.ems.EventManagementCategory;
import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import noticecast.debug.Debug;
import noticecast.exceptions.LogictierException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.persist.INCObjectUpdate;
import noticecast.persist.IPersistManager;
import noticecast.persist.NCObjectUpdateImpl;
import noticecast.persist.PersistManagerException;
import noticecast.persist.PersistWrapperException;
import noticecast.scheduling.nc.IScheduleFactory;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.nc.ScheduleDetails;
import noticecast.scheduling.nc.ScheduleFactoryException;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.FixedIntervalSchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.MonthlySchedule;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleConstants;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.scheduling.schedules.WeeklySchedule;
import noticecast.scheduling.schedules.YearlySchedule;
import noticecast.services.RepositoryServicesImpl;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;
import noticecast.util.ValidResult;
import noticecast.util.ValidityErrMsgs;

public class ScheduleFactoryImpl
implements IScheduleFactory,
ScheduleConstants {
    private static ScheduleFactoryImpl m_scheduleFactory;

    private ScheduleFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleFactoryImpl getInstance() {
        if (m_scheduleFactory != null) return m_scheduleFactory;
        Class<ScheduleFactoryImpl> clazz = ScheduleFactoryImpl.class;
        synchronized (ScheduleFactoryImpl.class) {
            if (m_scheduleFactory != null) return m_scheduleFactory;
            m_scheduleFactory = new ScheduleFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_scheduleFactory;
        }
    }

    @Override
    public synchronized ScheduleDetails createScheduleDetails(String name, String description, ScheduleType scheduleType, Date startDate, Date endDate, TimeZone tz, boolean repeatForever, int interval, boolean absolute, int dayOfMonth, int dayOfWeekInMonth, NcDayConstants dayOfWeek, NcMonthConstants monthOfYear, int daysOfWeek) throws ScheduleFactoryException {
        Schedule schedule = this.createSchedule(scheduleType, startDate, endDate, tz, repeatForever, interval, absolute, dayOfMonth, dayOfWeekInMonth, dayOfWeek, monthOfYear, daysOfWeek);
        ScheduleDetails sbd = new ScheduleDetails(name, description, "", scheduleType, schedule.getStartDate(), endDate, tz, repeatForever, interval, absolute, schedule.getDayOfMonth(), schedule.getDayOfWeekInMonth(), schedule.getDayOfWeek(), schedule.getMonthOfYear(), daysOfWeek);
        sbd.setIsValidSchedule(schedule.getScheduleValid());
        return sbd;
    }

    @Override
    public NcScheduleWrapper createSchedule(ScheduleDetails sbd) throws ScheduleFactoryException {
        Schedule schedule = this.createSchedule(sbd.getScheduleType(), sbd.getStartDate(), sbd.getEndDate(), sbd.getTimeZone(), sbd.getRepeatForever(), sbd.getInterval(), sbd.getAbsoluteDate(), sbd.getDayOfMonth(), sbd.getDayOfWeekInMonth(), sbd.getDayOfWeek(), sbd.getMonthOfYear(), sbd.getDaysOfWeek());
        return new NcScheduleWrapper(null, sbd.getName(), sbd.getDescription(), schedule);
    }

    @Override
    public INCFeatherWeight storeSchedule(ScheduleDetails scheduleDetails) throws ScheduleFactoryException {
        NcScheduleWrapper scheduleWrapper = this.createSchedule(scheduleDetails);
        NCObjectId scheduleId = scheduleDetails.getId();
        if (null == scheduleId) {
            scheduleId = NCObjectId.createNew();
            scheduleWrapper.setNCObjectId(scheduleId);
            this.storeNewSchedule(scheduleWrapper);
        } else {
            scheduleWrapper.setNCObjectId(scheduleId);
            this.storeExistingSchedule(scheduleWrapper, scheduleDetails.getUpdateStamp());
        }
        return this.getScheduleFeatherWeight(scheduleId);
    }

    private Schedule createSchedule(ScheduleType scheduleType, Date startDate, Date endDate, TimeZone tz, boolean repeatForever, int interval, boolean absolute, int dayOfMonth, int dayOfWeekInMonth, NcDayConstants dayOfWeek, NcMonthConstants monthOfYear, int daysOfWeek) throws ScheduleFactoryException {
        Schedule schedule = null;
        if (scheduleType.equals(ScheduleType.YEARLY_SCHEDULE)) {
            schedule = new YearlySchedule(scheduleType, startDate, endDate, repeatForever, interval, absolute, dayOfMonth, dayOfWeekInMonth, dayOfWeek, monthOfYear, tz);
        } else if (scheduleType.equals(ScheduleType.MONTHLY_SCHEDULE)) {
            schedule = new MonthlySchedule(scheduleType, startDate, endDate, repeatForever, interval, absolute, dayOfMonth, dayOfWeekInMonth, dayOfWeek, tz);
        } else if (scheduleType.equals(ScheduleType.WEEKLY_SCHEDULE)) {
            schedule = new WeeklySchedule(scheduleType, startDate, endDate, repeatForever, interval, daysOfWeek, tz);
        } else if (scheduleType.equals(ScheduleType.DAILY_SCHEDULE)) {
            schedule = new DailySchedule(scheduleType, startDate, endDate, repeatForever, interval, tz);
        } else if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE)) {
            schedule = new FixedIntervalSchedule(scheduleType, startDate, endDate, repeatForever, interval, tz);
        } else if (scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE)) {
            schedule = new FixedIntervalSchedule(scheduleType, startDate, endDate, repeatForever, interval, tz);
        } else if (scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            schedule = new FixedIntervalSchedule(scheduleType, startDate, endDate, repeatForever, interval, tz);
        } else {
            System.out.println("problem with create schedule");
            throw new ScheduleFactoryException();
        }
        return schedule;
    }

    @Override
    public ScheduleDetails getExistingScheduleDetails(NCObjectId scheduleId, TimeZone tz) {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        INCObjectUpdate updateObject = null;
        NcScheduleWrapper scheduleWrapper = null;
        int updateStamp = -999;
        try {
            updateObject = pm.findNCObjectUpdateByOid(scheduleId, NCObjectType.SCHEDULE, null);
            scheduleWrapper = (NcScheduleWrapper)updateObject.getObject();
            updateStamp = updateObject.getStamp();
        }
        catch (PersistManagerException ex) {
            String errmsg = "Error getting a schedule object";
            this.logAnError(errmsg, (Throwable)((Object)ex));
        }
        ISchedule schedule = scheduleWrapper.getSchedule();
        int dayOfMonth = schedule.getDayOfMonth();
        int dayOfWeekInMonth = schedule.getDayOfWeekInMonth();
        NcDayConstants dayOfWeek = schedule.getDayOfWeek();
        NcMonthConstants monthOfYear = schedule.getMonthOfYear();
        int daysOfWeek = 0;
        if (schedule instanceof WeeklySchedule) {
            daysOfWeek = ((WeeklySchedule)schedule).getDaysOfWeek();
        }
        Calendar endCal = schedule.getEndAt();
        ScheduleDetails sbd = new ScheduleDetails(scheduleWrapper.getName(), scheduleWrapper.getDescription(), "", schedule.getType(), schedule.getStartDate(), endCal != null ? endCal.getTime() : null, schedule.getTimeZone(), schedule.getRepeatForever(), schedule.getRepeatInterval(), schedule.getUseDayNumber(), dayOfMonth, dayOfWeekInMonth, dayOfWeek, monthOfYear, daysOfWeek);
        sbd.setId(scheduleWrapper.getNCObjectId());
        sbd.setIsValidSchedule(schedule.getScheduleValid());
        sbd.setUpdateStamp(updateStamp);
        return sbd;
    }

    private void storeNewSchedule(NcScheduleWrapper scheduleWrapper) throws ScheduleFactoryException {
        this.storeNewSchedule(scheduleWrapper, NCObjectType.SCHEDULE, NCObjectType.NC_SCHEDULE);
    }

    private void storeNewSchedule(NcScheduleWrapper scheduleWrapper, NCObjectType objType, NCObjectType subType) throws ScheduleFactoryException {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        try {
            pm.storeNew(scheduleWrapper, objType, subType, null);
        }
        catch (PersistManagerException ex) {
            throw new ScheduleFactoryException(ex);
        }
    }

    private void storeExistingSchedule(NcScheduleWrapper scheduleWrapper, int updateStamp) throws ScheduleFactoryException {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        try {
            NCObjectUpdateImpl objUpdate = new NCObjectUpdateImpl(scheduleWrapper, NCObjectType.SCHEDULE, updateStamp);
            pm.store(objUpdate, null);
        }
        catch (LogictierException ex) {
            String errmsg = "[storeExistingSchedule] Logictier Exception in Schedule Factory.";
            this.logAnError(errmsg, (Throwable)((Object)ex));
            throw new ScheduleFactoryException();
        }
        catch (PersistManagerException ex) {
            throw new ScheduleFactoryException(ex);
        }
    }

    private INCFeatherWeight getScheduleFeatherWeight(NCObjectId scheduleId) throws ScheduleFactoryException {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        INCFeatherWeight featherWeight = null;
        try {
            featherWeight = pm.getFeatherWeight(scheduleId);
        }
        catch (PersistManagerException ex) {
            String errmsg = "Persist Manager Exception in Schedule Factory: getScheduleFeatherWeight";
            this.logAnError(errmsg, (Throwable)((Object)ex));
            throw new ScheduleFactoryException(ex);
        }
        return featherWeight;
    }

    @Override
    public ValidResult isValid(String schName) {
        ValidResult result = new ValidResult();
        if (schName == null) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.SCHEDULE_UNDEFINED);
        } else if (!this.isNameUnique(schName)) {
            result.setValid(false);
            result.setMsgId(ValidityErrMsgs.SCHEDULE_DUPLICATE);
        } else {
            result.setValid(true);
        }
        return result;
    }

    private boolean isNameUnique(String schName) {
        boolean result;
        block4: {
            result = true;
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            try {
                INCFeatherWeight[] dsNames = pm.getObjectList(NCObjectType.SCHEDULE, schName);
                INCFeatherWeight[] jdbcDsNames = pm.getObjectList(NCObjectType.SCHEDULE, schName);
                ArrayList<INCFeatherWeight> all = new ArrayList<INCFeatherWeight>(3);
                all.addAll(Arrays.asList(dsNames));
                all.addAll(Arrays.asList(jdbcDsNames));
                if (all.isEmpty()) break block4;
                String otherId = null;
                INCFeatherWeight oneObj2 = null;
                for (INCFeatherWeight oneObj2 : all) {
                    otherId = oneObj2.getName();
                    if (!otherId.equals(schName)) continue;
                    result = false;
                    break;
                }
            }
            catch (PersistWrapperException ex) {
                if (Debug.debug) {
                    ex.printStackTrace(System.err);
                }
                this.logAnError("exception caught in Schedule Factory isNameUnique", (Throwable)((Object)ex));
                result = false;
            }
        }
        return result;
    }

    private void logAnError(String mess, Throwable ex) {
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(mess + " " + ex.getMessage());
    }
}

