/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.nc;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.event.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import noticecast.logictier.base.INCFeatherWeight;
import noticecast.scheduling.nc.IScheduleRetriever;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.nc.ScheduleRetriever;
import noticecast.scheduling.schedules.ISchedule;

public class ScheduleLink
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private INCFeatherWeight m_featherWeightSchedule;
    private NcScheduleWrapper m_scheduleWrapper;
    private boolean m_isActive;
    private boolean m_isEscalation;
    private List m_overrideEvents;
    private List m_suspendedEvents;
    private IScheduleRetriever m_scheduleRetriever = new ScheduleRetriever();

    public ScheduleLink(INCFeatherWeight featherWeightSchedule, boolean isActive, boolean isEscalation) {
        this.m_featherWeightSchedule = featherWeightSchedule;
        this.m_isActive = isActive;
        this.m_isEscalation = isEscalation;
        this.m_overrideEvents = Collections.synchronizedList(new ArrayList());
        this.m_suspendedEvents = Collections.synchronizedList(new ArrayList());
    }

    ScheduleLink() {
        this.m_overrideEvents = Collections.synchronizedList(new ArrayList());
        this.m_suspendedEvents = Collections.synchronizedList(new ArrayList());
    }

    public ScheduleLink(INCFeatherWeight featherWeightSchedule) {
        this(featherWeightSchedule, false, false);
    }

    public INCFeatherWeight getScheduleFeatherWeight() {
        return this.m_featherWeightSchedule;
    }

    public NCObjectId getScheduleId() {
        return this.m_featherWeightSchedule.getNCObjectId();
    }

    public List getSuspendedEvents() {
        return new ArrayList(this.m_suspendedEvents);
    }

    public NcScheduleWrapper getSchedule() {
        if (this.m_scheduleWrapper == null) {
            this.m_scheduleWrapper = this.m_scheduleRetriever.getNcScheduleWrapper(this.getScheduleId());
        }
        return this.m_scheduleWrapper;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public boolean isEscalation() {
        return this.m_isEscalation;
    }

    public void setActive(boolean isActive) {
        this.m_isActive = isActive;
    }

    public void setEscalation(boolean isEscalation) {
        this.m_isEscalation = isEscalation;
    }

    public void setSchedule(NcScheduleWrapper scheduleWrapper) {
        this.m_scheduleWrapper = scheduleWrapper;
    }

    public void setScheduleFeatherWeight(INCFeatherWeight featherWeight) {
        this.m_featherWeightSchedule = featherWeight;
    }

    public boolean equals(Object object) {
        ScheduleLink link;
        boolean isEqual = false;
        if (object != null && object instanceof ScheduleLink && (link = (ScheduleLink)object).getScheduleId().equals(this.getScheduleId())) {
            isEqual = true;
        }
        return isEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOverrideEvent(Event event) {
        if (event.getStatus().equals((Object)EventStatus.SUSPENDED)) {
            this.m_suspendedEvents.add(event);
        } else {
            this.m_overrideEvents.add(event);
            List list = this.m_overrideEvents;
            synchronized (list) {
                Collections.sort(this.m_overrideEvents, new Event.RequestDateComparator());
            }
        }
    }

    public void removeOverrideEvent(Event event) {
        if (!this.m_overrideEvents.remove(event)) {
            this.m_suspendedEvents.remove(event);
        }
    }

    public Collection getOverrideEvents() {
        ArrayList allEvents = new ArrayList();
        allEvents.addAll(this.m_overrideEvents);
        allEvents.addAll(this.m_suspendedEvents);
        return allEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNextDelayedEvents(Date refDate, boolean inclusive) {
        ArrayList<Event> eventList = null;
        Date earliestEventDate = null;
        Date nextRequestedStartDate = null;
        List list = this.m_overrideEvents;
        synchronized (list) {
            for (Event next : this.m_overrideEvents) {
                nextRequestedStartDate = next.getRequestedStartDate();
                if (next.getRequestedStartDate() == null || refDate != null && !nextRequestedStartDate.after(refDate) && (!inclusive || !nextRequestedStartDate.equals(refDate))) continue;
                if (eventList == null) {
                    eventList = new ArrayList<Event>();
                    eventList.add(next);
                    earliestEventDate = nextRequestedStartDate;
                    continue;
                }
                if (nextRequestedStartDate.before(earliestEventDate)) {
                    eventList.clear();
                    eventList.add(next);
                    earliestEventDate = nextRequestedStartDate;
                    continue;
                }
                if (!nextRequestedStartDate.equals(earliestEventDate)) continue;
                eventList.add(next);
                earliestEventDate = nextRequestedStartDate;
            }
        }
        return eventList;
    }

    public Event getOverrideEvent(Date date) {
        Event event = null;
        Iterator itr = this.getOverrideEvents().iterator();
        while (event == null && itr.hasNext()) {
            Event next = (Event)itr.next();
            event = next.getScheduledStartDate().equals(date) ? next : null;
        }
        return event;
    }

    public boolean isOverrideDate(Date date) {
        Iterator itr = this.getOverrideEvents().iterator();
        boolean found = false;
        while (itr.hasNext() && !found) {
            Event event = (Event)itr.next();
            if (!event.getScheduledStartDate().equals(date)) continue;
            found = true;
        }
        return found;
    }

    public void verifyOverrideDates(Date nextRunDate) {
        ScheduleRunChecker checker = new ScheduleRunChecker();
        ISchedule schedule = this.getSchedule().getSchedule();
        TreeSet<Event> invalid_events = new TreeSet<Event>(new Event.RequestDateComparator());
        for (Event event : this.getOverrideEvents()) {
            Date date = event.getScheduledStartDate();
            Date runDate = event.getRunDate();
            if (!checker.willRun(date, date, schedule)) {
                invalid_events.add(event);
                continue;
            }
            if (runDate == null || !runDate.before(nextRunDate)) continue;
            invalid_events.add(event);
        }
        this.m_overrideEvents.removeAll(invalid_events);
        this.m_suspendedEvents.removeAll(invalid_events);
    }

    class ScheduleRunChecker {
        ScheduleRunChecker() {
        }

        public boolean willRun(Date overrideDate, Date nextRunDate, ISchedule schedule) {
            if (nextRunDate == null || overrideDate == null) {
                return false;
            }
            boolean found = false;
            if (overrideDate.equals(nextRunDate)) {
                found = true;
            }
            if (!found && overrideDate.after(nextRunDate)) {
                Date next = schedule.getNextExecuteInclusive(nextRunDate);
                while (!found && next != null && (overrideDate.after(next) || next.equals(overrideDate))) {
                    if (next.equals(overrideDate)) {
                        found = true;
                        continue;
                    }
                    next = schedule.getNextExecute(next);
                }
            }
            return found;
        }
    }
}

