/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.nc;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import noticecast.debug.Debug;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.base.INCBaseObjectConsumer;
import noticecast.logictier.base.NCBaseObjectImpl;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.task.TaskRunDetailsImpl;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.services.RepositoryServicesImpl;

public class TaskScheduleImpl
extends NCBaseObjectImpl
implements ITaskSchedule {
    static final long serialVersionUID = 70009003L;
    private static final int DEFAULT_RUN_OPTION = 1;
    private NCObjectId m_taskId;
    private ScheduleLink[] m_scheduleLinks;
    private Event[] m_nextRunEvents;
    private Date m_lastRunDate;
    private Date m_earliestRunDate;
    private int m_runOption = 1;
    private long m_delay;
    private transient boolean m_isTransient = false;
    private boolean m_deleteAfterLastRun = false;
    private Date m_nextRunDate;
    private boolean m_computeNextRunDate = true;
    private int m_priority = 3;
    private String m_ownerStoreID;
    private String tenantID;
    private static final String CAMID = "CAMID";
    private static final String CREDENTIAL = "credential";

    public TaskScheduleImpl() {
        this(null, null, null, 1, 0);
    }

    public TaskScheduleImpl(ScheduleLink[] scheduleLinks) {
        this(scheduleLinks, null, null, 1, 0);
    }

    public TaskScheduleImpl(ScheduleLink[] scheduleLinks, Date nextRunDate, Date lastRunDate, int runOption, int delay) {
        this.m_scheduleLinks = scheduleLinks == null ? new ScheduleLink[0] : scheduleLinks;
        this.m_nextRunDate = nextRunDate;
        this.m_lastRunDate = lastRunDate;
        this.m_runOption = runOption;
        this.m_delay = delay;
    }

    public TaskScheduleImpl(int runOption, Date lastRunDate, Date nextRunDate, long delay) {
        this(null, nextRunDate, lastRunDate, runOption, (int)delay);
    }

    @Override
    public boolean activateDelay() {
        String s = "TaskScheduleImpl.TaskScheduleImpl : SCHEDULING_TASKSCHEDULE_ACTIVATEDELAY_CALLED";
        AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)AuditStatus.BLANK);
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, null, (Object[])new String[]{s}, (Map)ap);
        boolean stateChanged = false;
        if (this.m_delay == 0L) {
            this.m_earliestRunDate = null;
            return stateChanged;
        }
        if (this.m_nextRunEvents != null && this.m_nextRunEvents.length > 0) {
            Date current = new Date();
            long nowTime = current.getTime();
            long millisToNextExecution = this.m_nextRunEvents[0].getRunDate().getTime() - nowTime;
            if (millisToNextExecution < this.m_delay) {
                long newMillisToNext = nowTime + this.m_delay;
                this.m_earliestRunDate = new Date(newMillisToNext);
                if (Debug.debug) {
                    System.out.println("Expect next time near: " + this.m_earliestRunDate.toString());
                }
                this.m_computeNextRunDate = true;
                stateChanged = true;
            }
        }
        return stateChanged;
    }

    @Override
    public Date getLastExecution() {
        return this.m_lastRunDate;
    }

    @Override
    public Date getNextExecution() {
        if (this.m_computeNextRunDate) {
            this.setNextRequiredExecution();
            this.m_computeNextRunDate = false;
        }
        if (this.m_nextRunEvents != null && this.m_nextRunEvents.length > 0) {
            return this.m_nextRunEvents[0].getRunDate();
        }
        return null;
    }

    @Override
    public int getRunOption() {
        return this.m_runOption;
    }

    @Override
    public ScheduleLink[] getScheduleLinks() {
        return this.m_scheduleLinks;
    }

    @Override
    public void setScheduleLinks(ScheduleLink[] scheduleLinks) {
        Event[] events;
        this.m_scheduleLinks = scheduleLinks == null ? new ScheduleLink[0] : scheduleLinks;
        if (this.m_nextRunDate != null && (events = this.getNextExecute(this.m_nextRunDate, true, true)) != null && events.length > 0) {
            ArrayList<Event> eventsList = new ArrayList<Event>();
            for (int i = 0; i < events.length; ++i) {
                if (!events[i].getRunDate().equals(this.m_nextRunDate)) continue;
                eventsList.add(events[i]);
            }
            if (eventsList.size() > 0) {
                this.m_nextRunEvents = eventsList.toArray(new Event[0]);
            }
        }
        this.m_earliestRunDate = null;
        this.m_computeNextRunDate = true;
    }

    @Override
    public long getDelay() {
        return this.m_delay;
    }

    @Override
    public void setLastExecutionDate(Date last_execution) {
        this.m_lastRunDate = last_execution;
    }

    @Override
    public void runTask(IRunTimeManager runTimeManager, ITask task) {
        this.m_lastRunDate = null;
        if (this.m_nextRunEvents != null && this.m_nextRunEvents.length > 0) {
            this.m_lastRunDate = this.m_nextRunEvents[0].getRunDate();
        }
        Event[] eventsToRun = this.m_nextRunEvents;
        this.setNextRequiredExecution();
        Date nextRunTime = null;
        if (this.m_nextRunEvents != null && this.m_nextRunEvents.length > 0) {
            nextRunTime = this.m_nextRunEvents[0].getRunDate();
        }
        this.m_computeNextRunDate = false;
        Event eventToRun = null;
        Date eventReqStDate = new Date();
        Date schReqStDate = new Date();
        for (int i = 0; eventsToRun != null && i < eventsToRun.length; ++i) {
            Event event = eventsToRun[i];
            eventReqStDate = event.getRequestedStartDate();
            schReqStDate = event.getScheduledStartDate();
            if (event.isOverride()) {
                if (event.getStatus() != null && event.getStatus().equals((Object)EventStatus.CANCELLED)) {
                    String cancelledBy = this.resolveIfCredential(event.getCancelUser());
                    event.setCancelUser(cancelledBy);
                }
                this.removeOverrideEvent(event);
            }
            if (eventToRun == null) {
                eventToRun = event;
                continue;
            }
            if (!event.getStatus().equals((Object)EventStatus.SCHEDULED) || !event.getScheduledStartDate().after(eventToRun.getScheduledStartDate())) continue;
            eventToRun = event;
        }
        if (eventToRun == null) {
            String requestedDate = DateFormat.getDateInstance().format(eventReqStDate);
            String schduledDate = DateFormat.getDateInstance().format(schReqStDate);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ALL, null, new Object[]{"An Event found is not supposed to run now, it will run on its scheduled time, details of event are: requested date" + requestedDate + ", scheduled date " + schduledDate});
        } else {
            TaskRunDetailsImpl trd = new TaskRunDetailsImpl(eventToRun, this, nextRunTime);
            runTimeManager.runTask(task, this, trd);
        }
        List overridenEvents = this.getOverriddenEvents();
        for (Event overriddenEvent : overridenEvents) {
            if (overriddenEvent.getRequestedStartDate() == null || overriddenEvent.getRequestedStartDate().after(this.m_lastRunDate)) continue;
            this.removeOverrideEvent(overriddenEvent);
        }
    }

    @Override
    public void runTask(IRunTimeManager runTimeManager) {
        this.runTask(runTimeManager, null);
    }

    @Override
    public void setRunOption(int runOption) {
        this.m_runOption = runOption;
        this.m_earliestRunDate = null;
        this.m_computeNextRunDate = true;
    }

    @Override
    public void setDelay(long delay) {
        this.m_delay = delay;
        this.m_earliestRunDate = null;
        this.m_computeNextRunDate = true;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null && object instanceof ITaskSchedule) {
            ITaskSchedule taskSchedule = (ITaskSchedule)object;
            if (this.getNCObjectId().equals(taskSchedule.getNCObjectId())) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    private synchronized void setNextRequiredExecution() {
        Date current = new Date();
        this.setNextRequiredExecution(current);
    }

    private synchronized void setNextRequiredExecution(Date current) {
        Date referenceDate = this.m_lastRunDate;
        if (this.m_earliestRunDate != null) {
            if (current.before(this.m_earliestRunDate)) {
                current = this.m_earliestRunDate;
            }
            if (this.m_lastRunDate != null && this.m_earliestRunDate.after(this.m_lastRunDate)) {
                referenceDate = this.m_earliestRunDate;
            }
        }
        Event[] thisScheduleNextExecute = null;
        Event[] earliestExecute = null;
        if (this.m_runOption == 2) {
            thisScheduleNextExecute = this.getNextExecute(referenceDate, false, true);
            if (thisScheduleNextExecute != null && thisScheduleNextExecute.length > 0) {
                while (thisScheduleNextExecute != null && thisScheduleNextExecute.length > 0 && thisScheduleNextExecute[0].getRunDate().before(current)) {
                    thisScheduleNextExecute = this.getNextExecute(thisScheduleNextExecute[0].getRunDate(), false, true);
                }
            }
        } else {
            thisScheduleNextExecute = this.getNextExecute(current, false, true);
        }
        if (earliestExecute == null || earliestExecute.length == 0) {
            earliestExecute = thisScheduleNextExecute;
        }
        if (thisScheduleNextExecute != null && thisScheduleNextExecute.length > 0 && thisScheduleNextExecute[0].getRunDate().before(earliestExecute[0].getRunDate())) {
            earliestExecute = thisScheduleNextExecute;
        }
        this.m_nextRunEvents = earliestExecute;
        if (earliestExecute != null && earliestExecute.length > 0) {
            this.m_nextRunDate = earliestExecute[0].getRunDate();
        }
    }

    private ScheduleLink[] getActiveScheduleLinks() {
        Vector<ScheduleLink> list = new Vector<ScheduleLink>();
        if (this.m_scheduleLinks != null) {
            for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
                if (!this.m_scheduleLinks[i].isActive()) continue;
                list.add(this.m_scheduleLinks[i]);
            }
        }
        ScheduleLink[] scheduleLinks = new ScheduleLink[list.size()];
        list.toArray(scheduleLinks);
        return scheduleLinks;
    }

    @Override
    public void addScheduleLink(ScheduleLink scheduleLink) {
        boolean linkFound = false;
        NCObjectId linkId = scheduleLink.getScheduleId();
        for (int i = 0; i < this.m_scheduleLinks.length && !linkFound; ++i) {
            if (linkId != this.m_scheduleLinks[i].getScheduleId()) continue;
            linkFound = true;
        }
        if (!linkFound) {
            ScheduleLink[] newArray = new ScheduleLink[this.m_scheduleLinks.length + 1];
            for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
                newArray[i] = this.m_scheduleLinks[i];
            }
            newArray[this.m_scheduleLinks.length] = scheduleLink;
            this.m_scheduleLinks = newArray;
            this.m_earliestRunDate = null;
            this.m_computeNextRunDate = true;
        }
    }

    @Override
    public void addOverrideEvent(Event event) {
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            this.m_scheduleLinks[i].addOverrideEvent(event);
        }
    }

    private List getNextDelayedEvent(Date date, boolean inclusive) {
        List eventList = null;
        Date earliestEventDate = null;
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            List next;
            if (!this.m_scheduleLinks[i].isActive() || (next = this.m_scheduleLinks[i].getNextDelayedEvents(date, inclusive)) == null || next.size() <= 0) continue;
            Date nextDate = ((Event)next.get(0)).getRequestedStartDate();
            if (eventList == null) {
                eventList = next;
                earliestEventDate = nextDate;
                continue;
            }
            if (nextDate.before(earliestEventDate)) {
                eventList = next;
                earliestEventDate = nextDate;
                continue;
            }
            if (!nextDate.equals(earliestEventDate)) continue;
            eventList.addAll(next);
            earliestEventDate = nextDate;
        }
        return eventList;
    }

    @Override
    public void addOverrideEvent(Event event, NCObjectId schedule_id) {
        int i;
        if (schedule_id == null) {
            this.addOverrideEvent(event);
        } else {
            boolean found = false;
            for (i = 0; !found && i < this.m_scheduleLinks.length; ++i) {
                if (!this.m_scheduleLinks[i].getScheduleId().equals(schedule_id)) continue;
                found = true;
                this.m_scheduleLinks[i].addOverrideEvent(event);
            }
        }
        if (this.m_nextRunDate != null && event.getRunDate() != null && event.getRunDate().equals(this.m_nextRunDate)) {
            if (this.m_nextRunEvents == null) {
                this.m_nextRunEvents = new Event[]{event};
            } else {
                ArrayList<Event> nextRunEventsList = new ArrayList<Event>();
                for (i = 0; i < this.m_nextRunEvents.length; ++i) {
                    nextRunEventsList.add(this.m_nextRunEvents[i]);
                }
                int index = nextRunEventsList.indexOf(event);
                if (index >= 0) {
                    nextRunEventsList.set(index, event);
                } else {
                    nextRunEventsList.add(event);
                }
                this.m_nextRunEvents = nextRunEventsList.toArray(new Event[nextRunEventsList.size()]);
            }
        }
    }

    @Override
    public void removeOverrideEvent(Event event) {
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            this.m_scheduleLinks[i].removeOverrideEvent(event);
        }
    }

    @Override
    public void updateOverrideEvent(Event event, String caller) {
        Date now = new Date();
        Event existingEvent = this.getOverrideEvent(event.getScheduledStartDate());
        if (existingEvent != null) {
            if (event.getStatus() != null) {
                existingEvent.setStatus(event.getStatus());
                if (event.getStatus().equals((Object)EventStatus.CANCELLED)) {
                    existingEvent.setCancelUser(caller);
                }
            }
            if (event.getPriority() != null) {
                existingEvent.setPriority(event.getPriority());
            }
            if (event.getRequestedStartDate() != null) {
                if (event.getRequestedStartDate().after(now)) {
                    existingEvent.setRequestedStartDate(event.getRequestedStartDate());
                } else {
                    existingEvent.setRequestedStartDate(now);
                }
            }
            if (event.getStatus() != null && event.getStatus().equals((Object)EventStatus.SCHEDULED) && event.getRunDate().before(now)) {
                existingEvent.setRequestedStartDate(now);
            }
            if (this.isDefaultOverrideEvent(existingEvent)) {
                this.removeOverrideEvent(existingEvent);
            }
        } else {
            if (event.getStatus() == null) {
                event.setStatus(EventStatus.SCHEDULED);
            }
            if (!this.isDefaultOverrideEvent(event)) {
                if (event.getStatus() != null && event.getStatus().equals((Object)EventStatus.CANCELLED)) {
                    event.setCancelUser(caller);
                }
                if (event.getPriority() == null) {
                    event.setPriority(new Integer(this.m_priority));
                }
                this.addOverrideEvent(event);
            }
        }
        this.setNextRequiredExecution(now);
    }

    private boolean isDefaultOverrideEvent(Event event) {
        if (event.getStatus() != null && !event.getStatus().equals((Object)EventStatus.SCHEDULED)) {
            return false;
        }
        if (event.getPriority() != null && event.getPriority() != this.m_priority) {
            return false;
        }
        return !event.isDelayed();
    }

    @Override
    public Event getOverrideEvent(Date date) {
        Event event = null;
        for (int i = 0; event == null && i < this.m_scheduleLinks.length; ++i) {
            event = this.m_scheduleLinks[i].getOverrideEvent(date);
        }
        return event;
    }

    public List getOverriddenEvents() {
        ArrayList events = new ArrayList();
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            events.addAll(this.m_scheduleLinks[i].getOverrideEvents());
        }
        return events;
    }

    @Override
    public void verifyOverrideEvents() {
        Date refDate = null;
        if (this.isActive()) {
            if (this.m_nextRunEvents != null && this.m_nextRunEvents.length > 0) {
                refDate = this.m_nextRunEvents[0].getRunDate();
            }
        } else {
            Event[] events = this.getNextExecute(new Date(), false, false);
            if (events != null && events.length > 0) {
                refDate = events[0].getRunDate();
            }
        }
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            this.m_scheduleLinks[i].verifyOverrideDates(refDate);
        }
    }

    @Override
    public void removeScheduleLink(ScheduleLink scheduleLink) {
        boolean linkFound = false;
        int indexOfFoundLink = -1;
        NCObjectId linkId = scheduleLink.getScheduleId();
        for (int i = 0; i < this.m_scheduleLinks.length && !linkFound; ++i) {
            if (linkId != this.m_scheduleLinks[i].getScheduleId()) continue;
            linkFound = true;
            indexOfFoundLink = i;
        }
        if (linkFound) {
            ArrayList<ScheduleLink> newLinksList = new ArrayList<ScheduleLink>(this.m_scheduleLinks.length - 1);
            if (this.m_scheduleLinks.length - 1 > 0) {
                for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
                    if (i == indexOfFoundLink) continue;
                    newLinksList.add(this.m_scheduleLinks[i]);
                }
            }
            ScheduleLink[] newLinksArray = new ScheduleLink[newLinksList.size()];
            newLinksList.toArray(newLinksArray);
            this.m_scheduleLinks = newLinksArray;
            this.m_earliestRunDate = null;
            this.m_computeNextRunDate = true;
        }
    }

    @Override
    public NCObjectId getTaskId() {
        return this.m_taskId;
    }

    @Override
    public void setTaskId(NCObjectId oid) {
        this.m_taskId = oid;
    }

    @Override
    public boolean deactivateSchedules() {
        boolean statechanged = false;
        if (this.m_scheduleLinks != null) {
            for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
                if (!this.m_scheduleLinks[i].isActive()) continue;
                this.m_scheduleLinks[i].setActive(false);
                statechanged = true;
            }
        }
        if (statechanged) {
            this.m_earliestRunDate = null;
            this.m_computeNextRunDate = true;
        }
        return statechanged;
    }

    @Override
    public boolean activateSchedules() {
        boolean statechanged = false;
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            if (this.m_scheduleLinks[i].isActive()) continue;
            this.m_scheduleLinks[i].setActive(true);
            statechanged = true;
        }
        if (statechanged) {
            this.m_computeNextRunDate = true;
        }
        return statechanged;
    }

    @Override
    public boolean activateEscalationSchedules() {
        boolean statechanged = false;
        for (int i = 0; i < this.m_scheduleLinks.length; ++i) {
            if (this.m_scheduleLinks[i].isActive()) continue;
            this.m_scheduleLinks[i].setActive(true);
            statechanged = true;
        }
        if (statechanged) {
            this.m_computeNextRunDate = true;
        }
        return statechanged;
    }

    @Override
    public boolean deactivateEscalationSchedules() {
        return false;
    }

    @Override
    public boolean isActive() {
        boolean active = false;
        ScheduleLink[] scheduleLinks = this.getScheduleLinks();
        for (int i = 0; i < scheduleLinks.length && !active; ++i) {
            active = scheduleLinks[i].isActive();
        }
        return active;
    }

    @Override
    public boolean isTransient() {
        return this.m_isTransient;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.m_isTransient = isTransient;
    }

    @Override
    public void setDeleteAfterLastRun(boolean deleteAfterLastRun) {
        this.m_deleteAfterLastRun = deleteAfterLastRun;
    }

    @Override
    public boolean getDeleteAfterLastRun() {
        return this.m_deleteAfterLastRun;
    }

    @Override
    public Event getNextExecute(Date date) {
        Event[] events = this.getNextExecute(date, false, true);
        if (events == null || events.length == 0) {
            return null;
        }
        EventsSorter sorter = new EventsSorter(events);
        return (Event)sorter.getSortedEvents().get(0);
    }

    @Override
    public Event getNextExecuteInclusive(Date date) {
        Event[] events = this.getNextExecute(date, true, true);
        if (events == null || events.length == 0) {
            return null;
        }
        EventsSorter sorter = new EventsSorter(events);
        return (Event)sorter.getSortedEvents().get(0);
    }

    private Event[] getNextExecute(Date date, boolean inclusive, boolean activeSchedulesOnly) {
        List earliestDelayed;
        List events;
        Date earliestExecute = null;
        Enumeration scheduleIter = this.getSchedules(activeSchedulesOnly).elements();
        Date nextExecute = null;
        Event overrideEvent = null;
        while (scheduleIter.hasMoreElements()) {
            ISchedule schedule = (ISchedule)scheduleIter.nextElement();
            boolean recheckSchedule = true;
            while (recheckSchedule) {
                recheckSchedule = false;
                nextExecute = inclusive ? schedule.getNextExecuteInclusive(date) : schedule.getNextExecute(date);
                if (nextExecute == null || earliestExecute != null && !nextExecute.before(earliestExecute)) continue;
                earliestExecute = nextExecute;
                overrideEvent = this.getOverrideEvent(nextExecute);
                if (overrideEvent == null) continue;
                if (overrideEvent.getStatus().equals((Object)EventStatus.SUSPENDED) || overrideEvent.isDelayed()) {
                    overrideEvent = null;
                    recheckSchedule = true;
                    earliestExecute = null;
                    date = nextExecute;
                    inclusive = false;
                    continue;
                }
                if (overrideEvent.getStatus() == null) {
                    overrideEvent.setStatus(EventStatus.SCHEDULED);
                }
                if (overrideEvent.getPriority() != null) continue;
                overrideEvent.setPriority(new Integer(this.m_priority));
            }
        }
        Event normalEvent = overrideEvent;
        if (normalEvent == null && earliestExecute != null) {
            EventId id = new EventId(this.getTaskId(), earliestExecute);
            normalEvent = new Event(EventStatus.SCHEDULED, id);
            normalEvent.setPriority(new Integer(this.m_priority));
            normalEvent.setTenantID(this.tenantID);
        }
        if ((events = this.mergeEarliestEvents(earliestDelayed = this.getNextDelayedEvent(date, inclusive), normalEvent)) == null || events.size() == 0) {
            return null;
        }
        return events.toArray(new Event[events.size()]);
    }

    private List mergeEarliestEvents(List earliestDelayedEvents, Event event) {
        if (event == null) {
            return earliestDelayedEvents;
        }
        if (earliestDelayedEvents == null) {
            earliestDelayedEvents = new ArrayList<Event>();
        }
        if (earliestDelayedEvents.size() == 0) {
            earliestDelayedEvents.add(event);
            return earliestDelayedEvents;
        }
        Date earliestInList = ((Event)earliestDelayedEvents.get(0)).getRequestedStartDate();
        Date eventDate = event.getRunDate();
        if (eventDate.before(earliestInList)) {
            earliestDelayedEvents.clear();
            earliestDelayedEvents.add(event);
        } else if (eventDate.equals(earliestInList)) {
            earliestDelayedEvents.add(event);
        }
        return earliestDelayedEvents;
    }

    private Vector getSchedules(boolean activeOnly) {
        Vector<ISchedule> scheduleList = new Vector<ISchedule>();
        ScheduleLink[] links = this.getScheduleLinks();
        for (int i = 0; i < links.length; ++i) {
            NcScheduleWrapper sw;
            if (activeOnly && !links[i].isActive() || (sw = links[i].getSchedule()).getSchedule() == null) continue;
            scheduleList.add(sw.getSchedule());
        }
        return scheduleList;
    }

    public int hashCode() {
        return this.getNCObjectId().hashCode();
    }

    private NcScheduleWrapper getScheduleFromPersistStore(NCObjectId scheduleId) {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        NcScheduleWrapper scheduleWrapper = null;
        try {
            INCBaseObjectConsumer baseObject = pm.findNCObjectConsumerCopyByOid(scheduleId, NCObjectType.SCHEDULE);
            if (baseObject instanceof NcScheduleWrapper) {
                scheduleWrapper = (NcScheduleWrapper)baseObject;
            }
        }
        catch (PersistManagerException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_RUNTIMEMANAGERLOADSCHEDULES_TASKSCH, (Map)ap);
        }
        return scheduleWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveIfCredential(String userName) {
        if (userName != null && userName.startsWith(CAMID) && userName.indexOf(CREDENTIAL) > 0) {
            String credentialPath = userName;
            BiBusHeader userHeader = new BiBusHeader();
            CAM cam = new CAM();
            cam.setCAMCredentialPath(credentialPath);
            userHeader.setCAM(cam);
            Tracking tracking = new Tracking();
            userHeader.setTracking(tracking);
            JobBiBusHeaders headers = new JobBiBusHeaders(userHeader);
            boolean doLogoff = false;
            try {
                AuthenticatorFactory.getInstance().logon(headers);
                doLogoff = true;
                UserAccountUtil uau = new UserAccountUtil(headers);
                userName = uau.getUserName();
            }
            catch (Throwable e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e);
            }
            finally {
                if (doLogoff) {
                    try {
                        AuthenticatorFactory.getInstance().logoff(headers.getBiBusHeader());
                    }
                    catch (Throwable e) {
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e);
                    }
                }
            }
        }
        return userName;
    }

    @Override
    public int getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    @Override
    public String getOwnerStoreID() {
        return this.m_ownerStoreID;
    }

    @Override
    public void setOwnerStoreID(String ownerStoreID) {
        this.m_ownerStoreID = ownerStoreID;
    }

    @Override
    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    @Override
    public String getTenantID() {
        return this.tenantID;
    }

    public static class EventsSorter {
        private Collection m_scheduledEvents = new TreeSet<Event>(new Event.RequestDateComparator(false));
        private List m_cancelledEvents = new ArrayList();

        public EventsSorter(Collection events) {
            this.addAll(events);
        }

        public EventsSorter(Event[] events) {
            this.addEvents(events);
        }

        public void addAll(Collection events) {
            for (Event event : events) {
                if (event.getStatus().equals((Object)EventStatus.CANCELLED)) {
                    this.m_cancelledEvents.add(event);
                    continue;
                }
                this.m_scheduledEvents.add(event);
            }
        }

        public void addEvents(Event[] events) {
            for (int i = 0; i < events.length; ++i) {
                if (events[i].getStatus().equals((Object)EventStatus.CANCELLED)) {
                    this.m_cancelledEvents.add(events[i]);
                    continue;
                }
                this.m_scheduledEvents.add(events[i]);
            }
        }

        public List getSortedEvents() {
            ArrayList list = new ArrayList();
            list.addAll(this.m_scheduledEvents);
            list.addAll(this.m_cancelledEvents);
            return list;
        }
    }
}

