/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import noticecast.scheduling.schedules.HourInvariantSchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class DailySchedule
extends HourInvariantSchedule {
    static final long serialVersionUID = 70009003L;

    public DailySchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    public DailySchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInDays, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, tz);
        this.m_repeat_interval = intervalInDays;
        if (this.getEndAt() != null) {
            if (this.getEndAt().after(this.getExecuteFirst())) {
                this.setScheduleValid(true);
            }
        } else {
            this.setScheduleValid(true);
        }
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = this.getStartDateString(dateFormatter);
        String startTimeString = this.getStartTimeString(timeFormatter);
        String description = null;
        String endDateString = "";
        if (!this.m_repeat_forever) {
            endDateString = this.getEndDateString(dateFormatter);
        }
        description = "Run at " + startTimeString + " every " + this.m_repeat_interval + " days(s) effective " + startDateString + endDateString;
        return description + "\n" + this.getTimeZone().getID();
    }

    @Override
    protected Date getNextExecuteImpl(Date lastEffectiveExecute) {
        if (lastEffectiveExecute == null) {
            return this.getExecuteFirst().getTime();
        }
        if (this.getExecuteFirst().getTime().after(lastEffectiveExecute)) {
            return this.getExecuteFirst().getTime();
        }
        if (!this.getRepeatForever() && lastEffectiveExecute.after(this.getEndAt().getTime())) {
            return null;
        }
        Calendar lastExecute = Calendar.getInstance((TimeZone)this.getTimeZone());
        lastExecute.setTime(lastEffectiveExecute);
        Calendar nextExecute = (Calendar)this.getExecuteFirst().clone();
        if (!this.getExecuteFirst().after(lastExecute)) {
            while (!nextExecute.after(lastExecute)) {
                this.add(nextExecute, 5, 1);
            }
        }
        if (this.isValidDay(nextExecute.getTime())) {
            if (!nextExecute.after(lastExecute)) {
                this.add(nextExecute, 5, 1);
                while (!this.isValidDay(nextExecute.getTime())) {
                    this.add(nextExecute, 5, 1);
                }
            }
        } else {
            while (!this.isValidDay(nextExecute.getTime())) {
                this.add(nextExecute, 5, 1);
            }
        }
        if (!this.getRepeatForever() && nextExecute.after(this.getEndAt())) {
            return null;
        }
        return nextExecute.getTime();
    }

    @Override
    public Date getPreviousExecute(Date referenceDate) {
        throw new UnsupportedOperationException();
    }

    private boolean isValidDay(Date checkDate) {
        long denominator;
        boolean isValid = false;
        Date startOfDayOfSchedule = new Date();
        startOfDayOfSchedule = this.startOfDay(this.getExecuteFirst().getTime());
        long numerator = checkDate.getTime() - startOfDayOfSchedule.getTime();
        long remainder = numerator % (denominator = (long)this.m_repeat_interval * 86400000L);
        if (remainder <= 86399999L) {
            isValid = true;
        }
        return isValid;
    }

    private Date startOfDay(Date checkDate) {
        Calendar temp = Calendar.getInstance((TimeZone)this.getTimeZone());
        temp.setTime(checkDate);
        temp.set(11, 0);
        temp.set(12, 0);
        temp.set(13, 0);
        temp.set(14, 0);
        return temp.getTime();
    }

    private static ISchedule getDailySchedule(DateFormat formatter, String startDateString, String endDateString, boolean repeatForever, int interval) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = formatter.parse(startDateString);
            endDate = formatter.parse(endDateString);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        DailySchedule schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, startDate, endDate, false, 1, TimeZone.getDefault());
        return schedule;
    }
}

