/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.IntradayRecurrenceSchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class DailyScheduleWithIntradayRecurrence
extends IntradayRecurrenceSchedule {
    public DailyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int interval, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, start, end, repeatForever, interval, tz);
    }

    public DailyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = dateFormatter.format(this.m_schedule.getStartDate());
        String startTimeString = timeFormatter.format(this.m_schedule.getStartDate());
        String description = null;
        String endDateString = "";
        if (!this.m_schedule.getRepeatForever()) {
            endDateString = " until " + timeFormatter.format(this.m_schedule.getEndDate()) + " " + dateFormatter.format(this.m_schedule.getEndDate());
        }
        description = "Run " + this.getIntradayFrequencyString() + " on every " + this.m_schedule.getRepeatInterval() + " days(s) effective " + startTimeString + " " + startDateString + endDateString;
        return description + " " + this.getTimeZone().getID();
    }
}

