/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class FixedIntervalSchedule
extends Schedule {
    static final long serialVersionUID = 70009003L;
    private long m_repeat_interval_in_millis;
    public static final String _classId = "$Id: FixedIntervalSchedule.java,v 1.12 1999/12/21 14:45:43 johns Exp $";

    public FixedIntervalSchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, long fixedIntervalInMillis, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
        this.m_repeat_interval_in_millis = fixedIntervalInMillis;
    }

    public FixedIntervalSchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int interval, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, tz);
        this.m_repeat_interval = interval;
        if (scheduleType.equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE)) {
            this.m_repeat_interval_in_millis = (long)interval * 3600000L;
        } else if (scheduleType.equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE)) {
            this.m_repeat_interval_in_millis = (long)interval * 60000L;
        } else if (scheduleType.equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            this.m_repeat_interval_in_millis = (long)interval * 1000L;
        } else {
            System.out.println("Unknown interval type");
        }
        if (this.getEndAt() != null) {
            if (!this.getExecuteFirst().after(this.getEndAt())) {
                this.setScheduleValid(true);
            }
        } else {
            this.setScheduleValid(true);
        }
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = this.getStartDateString(dateFormatter);
        String startTimeString = this.getStartTimeString(timeFormatter);
        String interval_type = "";
        if (this.getType().equals(ScheduleType.FIXED_INT_SECOND_SCHEDULE)) {
            interval_type = " second(s)";
        } else if (this.getType().equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE)) {
            interval_type = " minute(s)";
        } else if (this.getType().equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE)) {
            interval_type = " hour(s)";
        }
        String endDateString = "";
        if (!this.m_repeat_forever) {
            endDateString = this.getEndDateString(dateFormatter);
        }
        String description = "Run at " + startTimeString + " every " + this.m_repeat_interval + " " + interval_type + " effective " + startDateString + endDateString;
        return description + "\n" + this.getTimeZone().getID();
    }

    @Override
    public Date getNextExecute(Date lastEffectiveExecute) {
        if (lastEffectiveExecute == null) {
            return this.getExecuteFirst().getTime();
        }
        if (this.getExecuteFirst().getTime().after(lastEffectiveExecute)) {
            return this.getExecuteFirst().getTime();
        }
        if (!this.getRepeatForever() && lastEffectiveExecute.after(this.getEndAt().getTime())) {
            return null;
        }
        Date executeFirst = this.getExecuteFirst().getTime();
        int dstOffset = this.calculateDSToffset(executeFirst, lastEffectiveExecute);
        long nextTimeOffsetFromStart = 0L;
        if (this.m_repeat_interval_in_millis != 0L) {
            long intervalsCompleted = (lastEffectiveExecute.getTime() - executeFirst.getTime() - (long)dstOffset) / this.m_repeat_interval_in_millis;
            nextTimeOffsetFromStart = (intervalsCompleted + 1L) * this.m_repeat_interval_in_millis + (long)dstOffset;
        }
        Date nextExecute = new Date();
        nextExecute.setTime(executeFirst.getTime() + nextTimeOffsetFromStart);
        if (!this.getRepeatForever() && nextExecute.after(this.getEndAt().getTime())) {
            return null;
        }
        return nextExecute;
    }

    @Override
    public Date getPreviousExecute(Date referenceDate) {
        throw new UnsupportedOperationException();
    }

    public long getRepeatIntervalInMillis() {
        return this.m_repeat_interval_in_millis;
    }
}

