/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public abstract class HourInvariantSchedule
extends Schedule {
    private int m_hourInvariant = this.getExecuteFirst().get(11);
    private int m_minuteInvariant = this.getExecuteFirst().get(12);
    protected boolean m_resetTimeOnNextUpdate = false;
    private int m_resetHourOnNextUpdate1 = 0;
    private int m_resetMinuteOnNextUpdate1 = 0;
    private static final int MINUTES_IN_HOUR = 60;

    public HourInvariantSchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    public HourInvariantSchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, tz);
    }

    void add(Calendar cal, int field, int count) {
        cal.add(field, count);
        this.checkHourMinFields(cal);
    }

    void set(Calendar cal, int[] fields, int[] values) {
        Date date = cal.getTime();
        for (int i = 0; i < fields.length; ++i) {
            cal.set(fields[i], values[i]);
        }
        Date newDate = cal.getTime();
        if (date.getTime() != newDate.getTime()) {
            this.checkHourMinFields(cal);
        }
    }

    void set(Calendar cal, int field, int value) {
        this.set(cal, new int[]{field}, new int[]{value});
    }

    private void checkHourMinFields(Calendar cal) {
        if (this.m_resetTimeOnNextUpdate) {
            if (this.m_resetHourOnNextUpdate1 != 0) {
                cal.add(11, this.m_resetHourOnNextUpdate1);
            }
            if (this.m_resetMinuteOnNextUpdate1 != 0) {
                cal.add(12, this.m_resetMinuteOnNextUpdate1);
            }
            this.reset();
            return;
        }
        if (cal.get(11) != this.m_hourInvariant || cal.get(12) != this.m_minuteInvariant) {
            int[] hourAndMinDiff = HourInvariantSchedule.getSmallestDiff(cal.get(11) * 60 + cal.get(12), this.m_hourInvariant * 60 + this.m_minuteInvariant);
            this.m_resetHourOnNextUpdate1 = hourAndMinDiff[0];
            this.m_resetMinuteOnNextUpdate1 = hourAndMinDiff[1];
            this.m_resetTimeOnNextUpdate = true;
            if (this.m_resetHourOnNextUpdate1 > 0) {
                cal.add(11, this.m_resetHourOnNextUpdate1);
                cal.add(12, this.m_resetMinuteOnNextUpdate1);
                this.m_resetHourOnNextUpdate1 = -this.m_resetHourOnNextUpdate1;
                this.m_resetMinuteOnNextUpdate1 = -this.m_resetMinuteOnNextUpdate1;
            }
        }
    }

    @Override
    public Date getNextExecute(Date lastEffectiveExecute) {
        this.reset();
        return this.getNextExecuteImpl(lastEffectiveExecute);
    }

    protected abstract Date getNextExecuteImpl(Date var1);

    private static int[] getSmallestDiff(int minsA, int minsB) {
        int diff = 0;
        int clockwise = 0;
        int anticlockwise = 0;
        if (minsB < minsA) {
            clockwise = 1440 - minsA + minsB;
            anticlockwise = minsA - minsB;
        } else {
            clockwise = minsB - minsA;
            anticlockwise = 1440 - minsB + minsA;
        }
        diff = anticlockwise < clockwise ? -anticlockwise : clockwise;
        int offsetHours = diff / 60;
        int offsetMinutes = diff % 60;
        return new int[]{offsetHours, offsetMinutes};
    }

    private void reset() {
        this.m_resetTimeOnNextUpdate = false;
        this.m_resetHourOnNextUpdate1 = 0;
        this.m_resetMinuteOnNextUpdate1 = 0;
    }

    public static void main(String[] args) {
        int diff = 0;
        diff = HourInvariantSchedule.getSmallestDiff(1380, 120)[0];
        System.out.println("Diff: " + diff);
        diff = HourInvariantSchedule.getSmallestDiff(120, 1380)[0];
        System.out.println("Diff: " + diff);
        diff = HourInvariantSchedule.getSmallestDiff(120, 300)[0];
        System.out.println("Diff: " + diff);
        diff = HourInvariantSchedule.getSmallestDiff(720, 900)[0];
        System.out.println("Diff: " + diff);
        diff = HourInvariantSchedule.getSmallestDiff(900, 720)[0];
        System.out.println("Diff: " + diff);
        diff = HourInvariantSchedule.getSmallestDiff(1380, 1380)[0];
        System.out.println("Diff: " + diff);
    }
}

