/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.FixedIntervalSchedule;
import noticecast.scheduling.schedules.IIntradayRecurrenceSchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public abstract class IntradayRecurrenceSchedule
implements IIntradayRecurrenceSchedule {
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_MINUTE = 60;
    protected ISchedule m_schedule;
    private ScheduleType m_scheduleType = null;
    protected int m_intradayRecurrenceStart;
    protected int m_intradayRecurrenceEnd;
    protected int m_intradayRecurrenceInterval;

    public IntradayRecurrenceSchedule(ScheduleType scheduleType, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        this.m_scheduleType = scheduleType;
        this.m_intradayRecurrenceStart = intradayRecurrenceStart;
        this.m_intradayRecurrenceEnd = intradayRecurrenceEnd;
        this.m_intradayRecurrenceInterval = intradayRecurrenceInterval;
    }

    @Override
    public int getDayOfMonth() {
        return this.m_schedule.getDayOfMonth();
    }

    @Override
    public NcDayConstants getDayOfWeek() {
        return this.m_schedule.getDayOfWeek();
    }

    @Override
    public int getDayOfWeekInMonth() {
        return this.m_schedule.getDayOfWeekInMonth();
    }

    @Override
    public Calendar getEndAt() {
        return this.m_schedule.getEndAt();
    }

    @Override
    public Date getEndDate() {
        return this.m_schedule.getEndDate();
    }

    @Override
    public Calendar getExecuteFirst() {
        return this.m_schedule.getExecuteFirst();
    }

    @Override
    public int getIntradayRecurrenceEnd() {
        return this.m_intradayRecurrenceEnd;
    }

    @Override
    public int getIntradayRecurrenceInterval() {
        return this.m_intradayRecurrenceInterval;
    }

    @Override
    public int getIntradayRecurrenceStart() {
        return this.m_intradayRecurrenceStart;
    }

    @Override
    public NcMonthConstants getMonthOfYear() {
        return this.m_schedule.getMonthOfYear();
    }

    @Override
    public Date getNextExecute(Date referenceDate) {
        if (this.isAfterEndDate(referenceDate)) {
            return null;
        }
        Date startOfDay = this.getStartOfDay(referenceDate);
        Date nextExecute = this.m_schedule.getNextExecute(startOfDay);
        int intradayRecurrenceStartWallTime = this.getWallTime(this.getStartDate(), this.m_intradayRecurrenceStart, this.getTimeZone());
        int intradayRecurrenceEndWallTime = this.getWallTime(this.getStartDate(), this.m_intradayRecurrenceEnd, this.getTimeZone());
        Date windowStart = this.getWindowStart(startOfDay, intradayRecurrenceStartWallTime);
        Date windowEnd = this.getWindowEnd(startOfDay, intradayRecurrenceEndWallTime);
        if (windowEnd.before(windowStart)) {
            if (referenceDate.before(windowEnd)) {
                if (this.checkIsValidDay(startOfDay = this.getStartOfPreviousDay(startOfDay))) {
                    nextExecute = windowStart = this.getWindowStart(startOfDay, intradayRecurrenceStartWallTime);
                } else {
                    windowStart = this.getNextStartWindow(windowEnd, intradayRecurrenceStartWallTime);
                    if (windowStart != null) {
                        windowEnd = this.getWindowEnd(windowStart, windowStart, intradayRecurrenceEndWallTime);
                    }
                }
            } else {
                windowStart = this.getNextStartWindow(windowEnd, intradayRecurrenceStartWallTime);
                if (windowStart != null) {
                    windowEnd = this.getWindowEnd(windowStart, windowStart, intradayRecurrenceEndWallTime);
                }
            }
        }
        if (windowStart != null && !this.checkIsValidDay(windowStart) && (windowStart = this.getNextStartWindow(windowEnd, intradayRecurrenceStartWallTime)) != null) {
            windowEnd = this.getWindowEnd(windowStart, windowStart, intradayRecurrenceEndWallTime);
        }
        Schedule fis = null;
        if (nextExecute != null) {
            Date startDate = this.getStartDate();
            if (startDate.before(windowStart)) {
                startDate = windowStart;
            }
            if (referenceDate.equals(nextExecute = (fis = new FixedIntervalSchedule(ScheduleType.FIXED_INT_SECOND_SCHEDULE, startDate, this.getEndDate(), this.getRepeatForever(), this.m_intradayRecurrenceInterval, this.getTimeZone())).getNextExecuteInclusive(windowStart)) || referenceDate.after(nextExecute)) {
                nextExecute = ((FixedIntervalSchedule)fis).getNextExecute(referenceDate);
            }
        }
        if (nextExecute != null && nextExecute.after(windowEnd)) {
            windowStart = this.getNextStartWindow(windowEnd, intradayRecurrenceStartWallTime);
            nextExecute = windowStart != null ? fis.getNextExecuteInclusive(windowStart) : null;
        }
        if (nextExecute != null && this.getEndDate() != null && nextExecute.after(this.getEndDate())) {
            nextExecute = null;
        }
        return nextExecute;
    }

    private boolean checkIsValidDay(Date date) {
        Calendar startOfDayCal1 = Calendar.getInstance((TimeZone)this.getTimeZone());
        startOfDayCal1.setTime(date);
        this.setToStartOfDay(startOfDayCal1);
        Date temp1 = startOfDayCal1.getTime();
        Date nextExecute = this.m_schedule.getNextExecuteInclusive(temp1);
        if (nextExecute == null) {
            return false;
        }
        Calendar startOfDayCal2 = Calendar.getInstance((TimeZone)this.getTimeZone());
        startOfDayCal2.setTime(nextExecute);
        this.setToStartOfDay(startOfDayCal2);
        return startOfDayCal1.equals((Object)startOfDayCal2);
    }

    private Date getNextStartWindow(Date date, int intradayRecurrenceStartWallTime) {
        Date nextStart = this.getWindowStart(date, intradayRecurrenceStartWallTime);
        if (nextStart.before(date) || nextStart.equals(date)) {
            Calendar cal1 = Calendar.getInstance((TimeZone)this.getTimeZone());
            cal1.setTime(nextStart);
            cal1.add(5, 1);
            nextStart = cal1.getTime();
        }
        if (!this.checkIsValidDay(nextStart)) {
            Date nextExecute = this.m_schedule.getNextExecute(nextStart);
            if (nextExecute == null) {
                return null;
            }
            nextStart = this.getWindowStart(nextExecute, intradayRecurrenceStartWallTime);
        }
        return nextStart;
    }

    private Date getStartOfDay(Date date) {
        Calendar startOfDayCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
        startOfDayCalendar.setTime(date);
        this.setToStartOfDay(startOfDayCalendar);
        return startOfDayCalendar.getTime();
    }

    private Date getStartOfPreviousDay(Date date) {
        Calendar startOfDayCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
        startOfDayCalendar.setTime(date);
        this.setToStartOfDay(startOfDayCalendar);
        startOfDayCalendar.add(5, -1);
        return startOfDayCalendar.getTime();
    }

    private Date getWindowStart(Date date, int intradayRecurrenceStartWallTime) {
        Calendar startOfIntraDayCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
        startOfIntraDayCalendar.setTime(date);
        this.setToStartOfDay(startOfIntraDayCalendar);
        Date startOfWindowDay = startOfIntraDayCalendar.getTime();
        startOfIntraDayCalendar.add(13, intradayRecurrenceStartWallTime);
        Date windowStart = startOfIntraDayCalendar.getTime();
        int dstOffset = this.calculateDSToffset(startOfWindowDay, windowStart);
        long dstAdjustedDate = windowStart.getTime() + (long)dstOffset;
        windowStart.setTime(dstAdjustedDate);
        return windowStart;
    }

    private Date getWindowEnd(Date windowStart, Date date, int intradayRecurrenceEndWallTime) {
        Calendar endOfIntraDayCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
        endOfIntraDayCalendar.setTime(date);
        this.setToStartOfDay(endOfIntraDayCalendar);
        endOfIntraDayCalendar.add(13, intradayRecurrenceEndWallTime);
        Date windowEnd = endOfIntraDayCalendar.getTime();
        if (windowEnd.before(windowStart)) {
            endOfIntraDayCalendar.add(5, 1);
            windowEnd = endOfIntraDayCalendar.getTime();
        }
        return windowEnd;
    }

    private Date getWindowEnd(Date date, int intradayRecurrenceEndWallTime) {
        Calendar endOfIntraDayCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
        endOfIntraDayCalendar.setTime(date);
        this.setToStartOfDay(endOfIntraDayCalendar);
        Date startOfWindowDay = endOfIntraDayCalendar.getTime();
        endOfIntraDayCalendar.add(13, intradayRecurrenceEndWallTime);
        Date windowEnd = endOfIntraDayCalendar.getTime();
        int dstOffset = this.calculateDSToffset(startOfWindowDay, windowEnd);
        long dstAdjustedDate = windowEnd.getTime() + (long)dstOffset;
        windowEnd.setTime(dstAdjustedDate);
        return windowEnd;
    }

    private boolean isAfterEndDate(Date date) {
        if (this.getRepeatForever()) {
            return false;
        }
        return date.after(this.getEndDate());
    }

    @Override
    public Date getNextExecuteInclusive(Date d) {
        if (d == null) {
            return null;
        }
        Date adjustedDate = new Date(d.getTime() - 1L);
        return this.getNextExecute(adjustedDate);
    }

    @Override
    public Date getPreviousExecute(Date referenceDate) {
        return null;
    }

    @Override
    public boolean getRepeatForever() {
        return this.m_schedule.getRepeatForever();
    }

    @Override
    public int getRepeatInterval() {
        return this.m_schedule.getRepeatInterval();
    }

    @Override
    public boolean getScheduleValid() {
        return this.m_schedule.getScheduleValid();
    }

    @Override
    public Date getStartDate() {
        return this.m_schedule.getStartDate();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.m_schedule.getTimeZone();
    }

    @Override
    public int calculateDSToffset(Date d1, Date d2) {
        return this.m_schedule.calculateDSToffset(d1, d2);
    }

    @Override
    public ScheduleType getType() {
        return this.m_scheduleType;
    }

    @Override
    public boolean getUseDayNumber() {
        return this.m_schedule.getUseDayNumber();
    }

    private void setToStartOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private int getWallTime(Date utcDate, int utcTimeInSeconds, TimeZone tz) {
        Calendar calLocalTZ = Calendar.getInstance((TimeZone)tz);
        calLocalTZ.setTime(utcDate);
        int expectedDay = calLocalTZ.get(5);
        Calendar calUTC = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"UTC"));
        calUTC.setTime(utcDate);
        int day = calUTC.get(5);
        this.setToStartOfDay(calUTC);
        day = calUTC.get(5);
        if (tz.useDaylightTime() && tz.inDaylightTime(utcDate)) {
            utcTimeInSeconds -= 3600;
        }
        calUTC.add(13, utcTimeInSeconds);
        Date utcAdjustedDate = calUTC.getTime();
        calUTC.setTimeZone(tz);
        day = calUTC.get(5);
        if (day != expectedDay) {
            int adjust = -1;
            if (utcAdjustedDate.before(utcDate)) {
                adjust = 1;
            }
            calUTC = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"UTC"));
            calUTC.setTime(utcDate);
            this.setToStartOfDay(calUTC);
            calUTC.add(5, adjust);
            calUTC.add(13, utcTimeInSeconds);
            calUTC.setTimeZone(tz);
        }
        int hours = calUTC.get(11);
        int mins = calUTC.get(12);
        int secs = calUTC.get(13);
        int result = 0;
        if (hours > 0) {
            result += hours * 3600;
        }
        if (mins > 0) {
            result += mins * 60;
        }
        if (secs > 0) {
            result += secs;
        }
        return result;
    }

    private int getTimeOfDay(Calendar cal) {
        int time = cal.get(11) * 3600;
        time += cal.get(12) * 60;
        return time += cal.get(13);
    }

    protected String getIntradayFrequencyString() {
        String start = this.getIntradayTimeString(this.getWallTime(this.getStartDate(), this.m_intradayRecurrenceStart, this.getTimeZone()));
        String end = this.getIntradayTimeString(this.getWallTime(this.getStartDate(), this.m_intradayRecurrenceEnd, this.getTimeZone()));
        String interval = this.getIntradayIntervalString(this.m_intradayRecurrenceInterval);
        String freq = "every " + interval + " between " + start + " until " + end;
        return freq;
    }

    private String getIntradayTimeString(int timeInSeconds) {
        String startMinuteString;
        String startHourString;
        int startHour = 0;
        int startMinute = 0;
        int startSecond = 0;
        if (timeInSeconds > 0) {
            startHour = timeInSeconds / 3600;
            int remSeconds = timeInSeconds % 3600;
            if (remSeconds > 0) {
                startMinute = remSeconds / 60;
                startSecond = remSeconds % 60;
            }
        }
        if ((startHourString = Integer.toString(startHour)).length() == 1) {
            startHourString = "0" + startHourString;
        }
        if ((startMinuteString = Integer.toString(startMinute)).length() == 1) {
            startMinuteString = "0" + startMinuteString;
        }
        String timeString = startHourString + ":" + startMinuteString;
        if (startSecond > 0) {
            timeString = timeString + ":" + startSecond;
        }
        return timeString;
    }

    private String getIntradayIntervalString(int timeInSeconds) {
        int intervalHour = 0;
        int intervalMinute = 0;
        int intervalSecond = 0;
        if (timeInSeconds > 0) {
            intervalHour = timeInSeconds / 3600;
            int remSeconds = timeInSeconds % 3600;
            if (remSeconds > 0) {
                intervalMinute = remSeconds / 60;
                intervalSecond = remSeconds % 60;
            }
        }
        String intervalString = "";
        if (intervalHour > 0) {
            intervalString = intervalString + Integer.toString(intervalHour) + " hour(s)";
        }
        if (intervalMinute > 0) {
            intervalString = intervalString + Integer.toString(intervalMinute) + " minute(s)";
        }
        if (intervalSecond > 0) {
            intervalString = intervalString + Integer.toString(intervalMinute) + " second(s)";
        }
        return intervalString;
    }
}

