/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.HourInvariantSchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class MonthlySchedule
extends HourInvariantSchedule {
    static final long serialVersionUID = 70009003L;
    public static final String _classId = "$Id: MonthlySchedule.java,v 1.12 1999/12/21 14:45:43 johns Exp $";

    public MonthlySchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    public MonthlySchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInMonths, boolean absoluteDate, int dayOfMonth, int dayOfWeekInMonth, NcDayConstants dayOfWeek, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, tz);
        this.m_repeat_interval = intervalInMonths;
        this.m_use_day_number = absoluteDate;
        this.m_day_of_month = dayOfMonth;
        this.m_day_of_week_in_month = dayOfWeekInMonth;
        this.m_day_of_week = dayOfWeek;
        this.setEffectiveStartDate();
        if (this.getEndAt() != null) {
            if (this.getEndAt().after(this.getExecuteFirst())) {
                this.setScheduleValid(true);
            }
        } else {
            this.setScheduleValid(true);
        }
    }

    private void setEffectiveStartDate() {
        Calendar cal = this.getExecuteFirst();
        if (this.m_use_day_number) {
            int startRangeDayNumber = cal.get(5);
            if (startRangeDayNumber <= this.m_day_of_month) {
                if (this.m_day_of_month > cal.getActualMaximum(5)) {
                    this.set(cal, 5, cal.getActualMaximum(5));
                } else {
                    this.set(cal, 5, this.m_day_of_month);
                }
            } else {
                this.set(cal, 5, this.m_day_of_month);
                this.add(cal, 2, 1);
            }
        } else {
            cal.clear(5);
            cal.clear(5);
            cal.clear(7);
            cal.clear(8);
            cal.clear(6);
            int[] fields = new int[]{7, 8};
            int[] values = new int[]{this.m_day_of_week.intValue(), this.m_day_of_week_in_month};
            this.set(cal, fields, values);
            if (cal.getTime().before(this.getStartDate())) {
                this.add(cal, 2, 1);
                fields = new int[]{7, 8};
                values = new int[]{this.m_day_of_week.intValue(), this.m_day_of_week_in_month};
                this.set(cal, fields, values);
            }
        }
        this.setStartDate(cal.getTime());
        this.m_month_of_year = NcMonthConstants.getMonth(cal.get(2));
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = this.getStartDateString(dateFormatter);
        String startTimeString = this.getStartTimeString(timeFormatter);
        String endDateString = this.m_repeat_forever ? "" : this.getEndDateString(dateFormatter);
        String description = null;
        if (this.m_use_day_number) {
            description = "Run at " + startTimeString + " on " + this.m_day_of_month + " day of every " + this.m_repeat_interval + " month(s) effective " + startDateString + endDateString;
        } else {
            String ordinalDayOfWeekInMonth = this.ordinalDayOfWeekInMonth(this.m_day_of_week_in_month);
            String stringWeekDay = this.m_day_of_week.toString();
            description = "Run at " + startTimeString + " on the " + ordinalDayOfWeekInMonth + " " + stringWeekDay + " of every " + this.m_repeat_interval + " month(s) effective " + startDateString + endDateString;
        }
        return description + "\n" + this.getTimeZone().getID();
    }

    @Override
    protected Date getNextExecuteImpl(Date referenceDate) {
        if (referenceDate == null) {
            return this.getExecuteFirst().getTime();
        }
        if (this.getExecuteFirst().getTime().after(referenceDate)) {
            return this.getExecuteFirst().getTime();
        }
        if (!this.getRepeatForever() && referenceDate.after(this.getEndAt().getTime())) {
            return null;
        }
        Calendar referenceCal = Calendar.getInstance((TimeZone)this.getTimeZone());
        referenceCal.setTime(referenceDate);
        Calendar nextExecute = this.getExecuteFirst();
        while (null != nextExecute && (nextExecute.before(referenceCal) || nextExecute.equals((Object)referenceCal))) {
            this.add(nextExecute, 2, this.m_repeat_interval);
            if (this.m_use_day_number) {
                nextExecute = this.getAbsoluteDateInMonth(nextExecute);
                continue;
            }
            nextExecute = this.getAbsoluteFromPositionalDateInMonth(nextExecute);
            if (this.getRepeatForever() || !nextExecute.after(this.getEndAt())) continue;
            return null;
        }
        if (!this.getRepeatForever() && nextExecute.after(this.getEndAt())) {
            return null;
        }
        return nextExecute.getTime();
    }

    @Override
    public Date getPreviousExecute(Date referenceDate) {
        throw new UnsupportedOperationException();
    }

    public Calendar getValidCalendarMonth(Calendar calendar) {
        Calendar validCalendar = null;
        if (calendar.getTime().before(this.getExecuteFirst().getTime())) {
            return null;
        }
        int startYear = this.getExecuteFirst().get(1);
        int startMonth = this.getExecuteFirst().get(2);
        int interval = this.getRepeatInterval();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int monthsFromStart = 0;
        if (year > startYear) {
            monthsFromStart = (startYear - year) * 12;
        }
        if ((monthsFromStart += month - startMonth) % interval == 0) {
            validCalendar = (Calendar)calendar.clone();
            if (this.m_use_day_number) {
                validCalendar.set(5, this.m_day_of_month);
            } else {
                calendar.set(7, this.m_day_of_week.intValue());
                calendar.set(8, this.m_day_of_week_in_month);
            }
            validCalendar.set(11, this.getExecuteFirst().get(11));
            validCalendar.set(12, this.getExecuteFirst().get(12));
            validCalendar.set(13, this.getExecuteFirst().get(13));
            validCalendar.set(14, this.getExecuteFirst().get(14));
        }
        return validCalendar;
    }

    private Calendar getAbsoluteDateInMonth(Calendar calendar) {
        while (calendar.get(5) < this.m_day_of_month && calendar.get(5) < calendar.getActualMaximum(5)) {
            this.add(calendar, 5, 1);
        }
        return calendar;
    }

    private Calendar getAbsoluteFromPositionalDateInMonth(Calendar calendar) {
        int[] calendarFields = new int[]{7, 8};
        int[] values = new int[]{this.m_day_of_week.intValue(), this.m_day_of_week_in_month};
        this.set(calendar, calendarFields, values);
        return calendar;
    }
}

