/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.IntradayRecurrenceSchedule;
import noticecast.scheduling.schedules.MonthlySchedule;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class MonthlyScheduleWithIntradayRecurrence
extends IntradayRecurrenceSchedule {
    public MonthlyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInMonths, boolean absoluteDate, int dayOfMonth, int dayOfWeekInMonth, NcDayConstants dayOfWeek, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new MonthlySchedule(ScheduleType.MONTHLY_SCHEDULE, start, end, repeatForever, intervalInMonths, absoluteDate, dayOfMonth, dayOfWeekInMonth, dayOfWeek, tz);
    }

    public MonthlyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new MonthlySchedule(ScheduleType.MONTHLY_SCHEDULE, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = timeFormatter.format(this.m_schedule.getStartDate()) + " " + dateFormatter.format(this.m_schedule.getStartDate());
        String endDateString = "";
        if (!this.m_schedule.getRepeatForever()) {
            endDateString = " until " + timeFormatter.format(this.m_schedule.getEndDate()) + " " + dateFormatter.format(this.m_schedule.getEndDate());
        }
        String description = null;
        if (this.m_schedule.getUseDayNumber()) {
            description = "Run " + this.getIntradayFrequencyString() + " on " + this.m_schedule.getDayOfMonth() + " day of every " + this.m_schedule.getRepeatInterval() + " month(s) effective " + startDateString + endDateString;
        } else {
            String ordinalDayOfWeekInMonth = ((Schedule)this.m_schedule).ordinalDayOfWeekInMonth(this.m_schedule.getDayOfWeekInMonth());
            String stringWeekDay = this.m_schedule.getDayOfWeek().toString();
            description = "Run " + this.getIntradayFrequencyString() + " on the " + ordinalDayOfWeekInMonth + " " + stringWeekDay + " of every " + this.m_schedule.getRepeatInterval() + " month(s) effective " + startDateString + endDateString;
        }
        return description + " " + this.getTimeZone().getID();
    }
}

