/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.io.Serializable;
import java.util.Date;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleConstants;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Schedule
implements ISchedule,
ScheduleConstants,
Serializable {
    public static final Logger logger = LogManager.getLogger((String)Schedule.class.getName());
    static final long serialVersionUID = 70009003L;
    protected ScheduleType m_scheduleType;
    protected Date m_start_date;
    protected Date m_end_date;
    protected boolean m_repeat_forever;
    protected boolean m_is_valid_schedule = false;
    protected boolean m_use_day_number;
    protected int m_day_of_month;
    protected NcDayConstants m_day_of_week;
    protected int m_day_of_week_in_month;
    protected NcMonthConstants m_month_of_year;
    protected int m_repeat_interval;
    private TimeZone m_timeZone;

    protected Schedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz) {
        this.m_scheduleType = scheduleType;
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        this.setRepeatForever(repeatForever);
        this.setScheduleValid(isValidSchedule);
        this.setUseDayNumber(useDayNumber);
        this.setDayOfMonth(dayOfMonth);
        this.setDayOfWeek(dayOfWeek);
        this.setDayOfWeekInMonth(dayOfWeekInMonth);
        this.setMonthOfYear(monthOfYear);
        this.setRepeatInterval(repeatInterval);
        this.setTimeZone(tz);
    }

    protected Schedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, TimeZone tz) {
        this.m_scheduleType = scheduleType;
        this.m_repeat_forever = repeatForever;
        this.m_repeat_interval = 1;
        this.m_use_day_number = true;
        this.setTimeZone(tz);
        this.initialiseStartDate(start);
        this.initialiseEndDate(end, repeatForever);
    }

    private void initialiseStartDate(Date start) {
        Calendar executeFirst = Calendar.getInstance((TimeZone)this.m_timeZone);
        executeFirst.setTime(start);
        this.m_day_of_month = executeFirst.get(5);
        this.m_day_of_week_in_month = executeFirst.get(8);
        this.m_day_of_week = NcDayConstants.getDay(executeFirst.get(7));
        this.m_month_of_year = NcMonthConstants.getMonth(executeFirst.get(2));
        this.m_start_date = start;
    }

    private void initialiseEndDate(Date endDate, boolean repeatForever) {
        if (!repeatForever) {
            this.m_end_date = endDate;
        }
    }

    @Override
    public abstract String getGeneratedDescription(DateTimeFormat var1, DateTimeFormat var2);

    @Override
    public Calendar getExecuteFirst() {
        Calendar executeFirst = Calendar.getInstance((TimeZone)this.getTimeZone());
        executeFirst.setTime(this.getStartDate());
        return executeFirst;
    }

    @Override
    public Calendar getEndAt() {
        Calendar endAt = null;
        if (this.m_end_date != null) {
            endAt = Calendar.getInstance((TimeZone)this.m_timeZone);
            endAt.setTime(this.m_end_date);
        }
        return endAt;
    }

    @Override
    public boolean getRepeatForever() {
        return this.m_repeat_forever;
    }

    @Override
    public abstract Date getNextExecute(Date var1);

    @Override
    public Date getNextExecuteInclusive(Date d) {
        if (d == null) {
            return null;
        }
        Date adjustedDate = new Date(d.getTime() - 1L);
        return this.getNextExecute(adjustedDate);
    }

    protected void setScheduleValid(boolean valid) {
        this.m_is_valid_schedule = valid;
    }

    @Override
    public boolean getScheduleValid() {
        return this.m_is_valid_schedule;
    }

    protected String ordinalDayOfWeekInMonth(int i) {
        switch (i) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case -1: {
                return "last";
            }
        }
        return "unknown";
    }

    protected String stringMonthOfYear(int i) {
        switch (i) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "unknown";
    }

    @Override
    public Date getEndDate() {
        return this.m_end_date;
    }

    @Override
    public int getDayOfMonth() {
        return this.m_day_of_month;
    }

    @Override
    public NcDayConstants getDayOfWeek() {
        return this.m_day_of_week;
    }

    @Override
    public int getDayOfWeekInMonth() {
        return this.m_day_of_week_in_month;
    }

    @Override
    public NcMonthConstants getMonthOfYear() {
        return this.m_month_of_year;
    }

    @Override
    public int getRepeatInterval() {
        return this.m_repeat_interval;
    }

    @Override
    public Date getStartDate() {
        return this.m_start_date;
    }

    @Override
    public ScheduleType getType() {
        return this.m_scheduleType;
    }

    @Override
    public boolean getUseDayNumber() {
        return this.m_use_day_number;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.m_timeZone;
    }

    private void setTimeZone(TimeZone tz) {
        this.m_timeZone = tz == null ? TimeZone.getTimeZone((String)"GMT") : tz;
    }

    private void setDayOfMonth(int dayOfMonth) {
        this.m_day_of_month = dayOfMonth;
    }

    private void setDayOfWeek(NcDayConstants dayOfWeek) {
        this.m_day_of_week = dayOfWeek;
    }

    private void setDayOfWeekInMonth(int dayOfWeekInMonth) {
        this.m_day_of_week_in_month = dayOfWeekInMonth;
    }

    private void setEndDate(Date endDate) {
        this.m_end_date = endDate;
    }

    private void setMonthOfYear(NcMonthConstants monthOfYear) {
        this.m_month_of_year = monthOfYear;
    }

    private void setRepeatForever(boolean repeatForever) {
        this.m_repeat_forever = repeatForever;
    }

    private void setRepeatInterval(int repeatInterval) {
        this.m_repeat_interval = repeatInterval;
    }

    protected void setStartDate(Date startDate) {
        this.m_start_date = startDate;
    }

    private void setUseDayNumber(boolean useDayNumber) {
        this.m_use_day_number = useDayNumber;
    }

    protected String getStartDateString(DateTimeFormat dateFormatter) {
        return dateFormatter.format(this.m_start_date);
    }

    protected String getStartTimeString(DateTimeFormat timeFormatter) {
        return timeFormatter.format(this.m_start_date);
    }

    protected String getEndDateString(DateTimeFormat dateFormatter) {
        String endDateString = "";
        if (!this.m_repeat_forever) {
            endDateString = " until " + dateFormatter.format(this.m_end_date);
        }
        return endDateString;
    }

    @Override
    public int calculateDSToffset(Date d1, Date d2) {
        int dstOffset = 0;
        TimeZone tz = this.getTimeZone();
        if (tz.useDaylightTime()) {
            if (tz.inDaylightTime(d1)) {
                dstOffset += tz.getDSTSavings();
            }
            if (tz.inDaylightTime(d2)) {
                dstOffset -= tz.getDSTSavings();
            }
        }
        return dstOffset;
    }
}

