/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleQueryResponse;
import noticecast.scheduling.schedules.ScheduleType;

public class ScheduleQuery {
    public static int MAX_COUNT = Integer.MAX_VALUE;
    public static int DEFAULT_COUNT = 1000;

    public static ScheduleQueryResponse getExecutionDates(ISchedule[] schedules, Date start) {
        LoopTest loopTest = new LoopTest(null, MAX_COUNT);
        return ScheduleQuery.doit(schedules, start, loopTest);
    }

    public static ScheduleQueryResponse getExecutionDates(ISchedule[] schedules, Date start, Date end) {
        LoopTest loopTest = new LoopTest(end, MAX_COUNT);
        return ScheduleQuery.doit(schedules, start, loopTest);
    }

    public static ScheduleQueryResponse getExecutionDates(ISchedule[] schedules, Date start, Date end, int count) {
        LoopTest loopTest = new LoopTest(end, count);
        return ScheduleQuery.doit(schedules, start, loopTest);
    }

    public static ScheduleQueryResponse getExecutionDates(ISchedule[] schedules, Date start, int count) {
        LoopTest loopTest = new LoopTest(null, count);
        return ScheduleQuery.doit(schedules, start, loopTest);
    }

    private static ScheduleQueryResponse doit(ISchedule[] schedules, Date start, LoopTest loopTest) {
        TreeSet<Date> dateSet = new TreeSet<Date>();
        ArrayList<ScheduleRunDate> scheduleList = new ArrayList<ScheduleRunDate>();
        for (int i = 0; i < schedules.length; ++i) {
            Date date = schedules[i].getNextExecuteInclusive(start);
            if (date == null) continue;
            scheduleList.add(new ScheduleRunDate(schedules[i], date));
        }
        int executeCount = 0;
        ScheduleRunDate srd = null;
        if (!scheduleList.isEmpty()) {
            if (scheduleList.size() > 1) {
                Collections.sort(scheduleList);
            }
            srd = (ScheduleRunDate)scheduleList.get(0);
        }
        while (!scheduleList.isEmpty() && loopTest.test(srd.date, executeCount)) {
            dateSet.add(srd.date);
            ++executeCount;
            Date nextExecute = srd.schedule.getNextExecute(srd.date);
            if (nextExecute == null) {
                scheduleList.remove(srd);
            } else {
                srd.date = nextExecute;
            }
            if (scheduleList.isEmpty()) continue;
            if (scheduleList.size() > 1) {
                Collections.sort(scheduleList);
            }
            srd = (ScheduleRunDate)scheduleList.get(0);
        }
        boolean isComplete = loopTest.isComplete() || scheduleList.isEmpty();
        return new ScheduleQueryResponse(dateSet, isComplete);
    }

    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss a zzz");
        formatter.setTimeZone(TimeZone.getDefault());
        ISchedule schedule1 = ScheduleQuery.getDailySchedule(formatter, "2002.05.01 at 11:00:00 AM GMT", "2002.05.04 at 11:00:00 AM GMT", false, 1);
        ISchedule schedule2 = ScheduleQuery.getDailySchedule(formatter, "2002.05.07 at 11:00:00 AM GMT", "2002.05.09 at 11:00:00 AM GMT", false, 1);
        Date testStart = null;
        Date testEnd = null;
        try {
            testStart = formatter.parse("2002.05.01 at 11:00:00 AM GMT");
            testEnd = formatter.parse("2002.05.09 at 11:00:00 AM GMT");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Start date - end date test:");
        ScheduleQuery queryObject = new ScheduleQuery();
        ScheduleQueryResponse response = ScheduleQuery.getExecutionDates(new ISchedule[]{schedule1, schedule2}, testStart, testEnd);
        for (Date responseDate : response.getDates()) {
            System.out.println(formatter.format(responseDate));
        }
        System.out.println("Start date - count date test:");
        queryObject = new ScheduleQuery();
        response = ScheduleQuery.getExecutionDates(new ISchedule[]{schedule1, schedule2}, testStart, 6);
        for (Date responseDate : response.getDates()) {
            System.out.println(formatter.format(responseDate));
        }
    }

    private static ISchedule getDailySchedule(DateFormat formatter, String startDateString, String endDateString, boolean repeatForever, int interval) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = formatter.parse(startDateString);
            endDate = formatter.parse(endDateString);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        DailySchedule schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, startDate, endDate, false, 1, com.cognos.i18n.TimeZone.getDefault());
        return schedule;
    }

    private static class LoopTest {
        private int count;
        private Date date;
        private boolean isComplete = false;

        public LoopTest(Date date, int count) {
            this.date = date;
            this.count = count;
        }

        public boolean test(Date testDate, int testCount) {
            boolean continueLoop = true;
            if (this.date != null && testDate.after(this.date)) {
                continueLoop = false;
                this.isComplete = true;
            }
            if (continueLoop && testCount >= this.count) {
                continueLoop = false;
                if (this.date == null) {
                    this.isComplete = true;
                }
            }
            return continueLoop;
        }

        public boolean isComplete() {
            return this.isComplete;
        }
    }

    private static class ScheduleRunDate
    implements Comparable {
        public ISchedule schedule;
        public Date date;

        public ScheduleRunDate(ISchedule schedule, Date date) {
            this.schedule = schedule;
            this.date = date;
        }

        public int compareTo(Object object) {
            ScheduleRunDate other = (ScheduleRunDate)object;
            if (this.schedule.equals(other.schedule) && this.date.equals(other.date)) {
                return 0;
            }
            return this.date.compareTo(other.date);
        }
    }
}

