/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.ems.EventManagementCategory;
import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.util.Date;
import noticecast.scheduling.schedules.HourInvariantSchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class WeeklySchedule
extends HourInvariantSchedule {
    static final long serialVersionUID = 70009003L;
    private int m_days_of_week;

    public WeeklySchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, int daysOfWeek, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
        this.m_days_of_week = daysOfWeek;
    }

    public WeeklySchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInWeeks, int daysOfWeek, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, tz);
        this.m_days_of_week = daysOfWeek;
        this.m_repeat_interval = intervalInWeeks;
        this.setEffectiveStartDate();
        if (this.getEndAt() != null) {
            if (this.getEndAt().after(this.getExecuteFirst())) {
                this.setScheduleValid(true);
            }
        } else {
            this.setScheduleValid(true);
        }
    }

    private void setEffectiveStartDate() {
        Calendar cal = this.getExecuteFirst();
        int i = cal.get(7);
        while (!this.isValidDay(i)) {
            cal.add(5, 1);
            i = cal.get(7);
        }
        this.setStartDate(cal.getTime());
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = this.getStartDateString(dateFormatter);
        String startTimeString = this.getStartTimeString(timeFormatter);
        String daysOfWeek = "";
        for (int i = NcDayConstants.SUNDAY.intValue(); i <= NcDayConstants.SATURDAY.intValue(); ++i) {
            if (!this.isValidDay(i)) continue;
            daysOfWeek = daysOfWeek + NcDayConstants.getLongStringValue(i);
            daysOfWeek = daysOfWeek + " ";
        }
        String endDateString = "";
        if (!this.m_repeat_forever) {
            endDateString = this.getEndDateString(dateFormatter);
        }
        String description = "Run at " + startTimeString + " every " + daysOfWeek + " effective " + startDateString + endDateString;
        return description + "\n" + this.getTimeZone().getID();
    }

    @Override
    protected Date getNextExecuteImpl(Date referenceDate) {
        if (referenceDate == null) {
            return this.getExecuteFirst().getTime();
        }
        if (this.getExecuteFirst().getTime().after(referenceDate)) {
            return this.getExecuteFirst().getTime();
        }
        if (!this.getRepeatForever() && referenceDate.after(this.getEndAt().getTime())) {
            return null;
        }
        Calendar referenceCal = Calendar.getInstance((TimeZone)this.getTimeZone());
        referenceCal.setTime(referenceDate);
        Calendar nextExecute = (Calendar)this.getExecuteFirst().clone();
        if (!this.getExecuteFirst().after(referenceCal)) {
            while (!nextExecute.after(referenceCal)) {
                this.add(nextExecute, 5, 1);
            }
        }
        boolean nextExecuteFound = false;
        if (!this.isValidWeek(nextExecute.getTime())) {
            while (nextExecute.get(7) != 1) {
                this.add(nextExecute, 5, 1);
            }
            while (!this.isValidWeek(nextExecute.getTime())) {
                this.add(nextExecute, 5, 7);
            }
            while (!this.isValidDay(nextExecute.get(7))) {
                this.add(nextExecute, 5, 1);
            }
            nextExecuteFound = true;
        } else if (this.isValidDay(nextExecute.get(7)) && nextExecute.after(referenceCal)) {
            nextExecuteFound = true;
        }
        while (!nextExecuteFound) {
            this.add(nextExecute, 5, 1);
            if (nextExecute.get(7) == 1) {
                while (!this.isValidWeek(nextExecute.getTime())) {
                    this.add(nextExecute, 5, 7);
                }
            }
            if (!this.isValidDay(nextExecute.get(7))) continue;
            nextExecuteFound = true;
        }
        if (!this.getRepeatForever() && nextExecute.after(this.getEndAt())) {
            return null;
        }
        return nextExecute.getTime();
    }

    @Override
    public Date getPreviousExecute(Date referenceDate) {
        throw new UnsupportedOperationException();
    }

    protected boolean isValidDay(int dayToCheck) {
        boolean isValid = false;
        try {
            int checkDay = (int)Math.pow(2.0, (double)dayToCheck - 1.0);
            if ((this.m_days_of_week & checkDay) == checkDay) {
                isValid = true;
            }
        }
        catch (ArithmeticException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Arithmetic Exception in Weekly Schedule: " + e.getLocalizedMessage());
        }
        return isValid;
    }

    protected boolean isValidWeek(Date checkDate) {
        long denominator;
        long numerator;
        long remainder;
        boolean isValid = false;
        Date startOfWeekOfSchedule = new Date();
        startOfWeekOfSchedule = this.startOfWeek(this.getExecuteFirst().getTime());
        int dstOffset = 0;
        if (this.getTimeZone().useDaylightTime()) {
            if (this.getTimeZone().inDaylightTime(startOfWeekOfSchedule)) {
                dstOffset += this.getTimeZone().getDSTSavings();
            }
            if (this.getTimeZone().inDaylightTime(checkDate)) {
                dstOffset += this.getTimeZone().getDSTSavings();
            }
        }
        if ((remainder = (numerator = checkDate.getTime() + (long)dstOffset - startOfWeekOfSchedule.getTime()) % (denominator = (long)this.m_repeat_interval * 604800000L)) <= 604799999L) {
            isValid = true;
        }
        return isValid;
    }

    private Date startOfWeek(Date checkDate) {
        Calendar temp = Calendar.getInstance((TimeZone)this.getTimeZone());
        temp.setTime(checkDate);
        while (temp.get(7) != 1) {
            temp.add(5, -1);
        }
        temp.set(10, 0);
        temp.set(12, 0);
        temp.set(13, 0);
        temp.set(14, 0);
        return temp.getTime();
    }

    public int getDaysOfWeek() {
        return this.m_days_of_week;
    }
}

