/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.FixedIntervalSchedule;
import noticecast.scheduling.schedules.IntradayRecurrenceSchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.scheduling.schedules.WeeklySchedule;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class WeeklyScheduleWithIntradayRecurrence
extends IntradayRecurrenceSchedule {
    public WeeklyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInWeeks, int daysOfWeek, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new WeeklySchedule(ScheduleType.WEEKLY_SCHEDULE, start, end, repeatForever, intervalInWeeks, daysOfWeek, tz);
        if (this.isStartDateGreaterThanOriginalStartDate(this.m_schedule.getStartDate(), start)) {
            this.setEffectiveStartTime(start, intradayRecurrenceStart);
        }
    }

    private boolean isStartDateGreaterThanOriginalStartDate(Date startDate, Date originalScheduleStartDate) {
        boolean isStartDateGreaterThanOriginalStartDate = false;
        if (startDate != null) {
            Calendar effectiveStartDate = Calendar.getInstance((TimeZone)this.getTimeZone());
            effectiveStartDate.setTime(startDate);
            effectiveStartDate = this.setToStartOfDay(effectiveStartDate);
            Calendar originalScheduleStartDateCalendar = Calendar.getInstance((TimeZone)this.getTimeZone());
            originalScheduleStartDateCalendar.setTime(originalScheduleStartDate);
            if (effectiveStartDate.after(originalScheduleStartDateCalendar)) {
                isStartDateGreaterThanOriginalStartDate = true;
            }
        }
        return isStartDateGreaterThanOriginalStartDate;
    }

    private void setEffectiveStartTime(Date originalScheduleStartDate, int intradayRecurrenceStart) {
        if (this.getStartDate() != null) {
            Calendar startDate = Calendar.getInstance((TimeZone)this.getTimeZone());
            startDate.setTime(this.getStartDate());
            startDate = this.setToStartOfDay(startDate);
            startDate.add(14, intradayRecurrenceStart * 1000);
            Date nextExecute = null;
            FixedIntervalSchedule fis = new FixedIntervalSchedule(ScheduleType.FIXED_INT_SECOND_SCHEDULE, originalScheduleStartDate, this.getEndDate(), this.getRepeatForever(), this.m_intradayRecurrenceInterval, this.getTimeZone());
            nextExecute = fis.getNextExecuteInclusive(startDate.getTime());
            if (nextExecute != null) {
                ((WeeklySchedule)this.m_schedule).setStartDate(nextExecute);
            }
        }
    }

    public Calendar setToStartOfDay(Calendar argCalendar) {
        argCalendar.set(11, 0);
        argCalendar.set(12, 0);
        argCalendar.set(13, 0);
        argCalendar.set(14, 0);
        return argCalendar;
    }

    public WeeklyScheduleWithIntradayRecurrence(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, int daysOfWeek, TimeZone tz, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) {
        super(scheduleType, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
        this.m_schedule = new WeeklySchedule(ScheduleType.WEEKLY_SCHEDULE, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, daysOfWeek, tz);
    }

    public int getDaysOfWeek() {
        return ((WeeklySchedule)this.m_schedule).getDaysOfWeek();
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = timeFormatter.format(this.m_schedule.getStartDate()) + " " + dateFormatter.format(this.m_schedule.getStartDate());
        String endDateString = "";
        if (!this.m_schedule.getRepeatForever()) {
            endDateString = " until " + timeFormatter.format(this.m_schedule.getEndDate()) + " " + dateFormatter.format(this.m_schedule.getEndDate());
        }
        String daysOfWeek = "";
        for (int i = NcDayConstants.SUNDAY.intValue(); i <= NcDayConstants.SATURDAY.intValue(); ++i) {
            if (!((WeeklySchedule)this.m_schedule).isValidDay(i)) continue;
            daysOfWeek = daysOfWeek + NcDayConstants.getLongStringValue(i);
            daysOfWeek = daysOfWeek + " ";
        }
        String description = "Run " + this.getIntradayFrequencyString() + " on every " + daysOfWeek + " effective " + startDateString + endDateString;
        return description + " " + this.getTimeZone().getID();
    }
}

