/*
 * Decompiled with CFR 0.152.
 */
package noticecast.scheduling.schedules;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import noticecast.scheduling.schedules.MonthlySchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

public class YearlySchedule
extends MonthlySchedule {
    static final long serialVersionUID = 70009003L;
    public static final String _classId = "$Id: YearlySchedule.java,v 1.11 1999/12/21 14:45:44 johns Exp $";

    public YearlySchedule(ScheduleType scheduleType, Date startDate, Date endDate, boolean repeatForever, boolean isValidSchedule, boolean useDayNumber, int dayOfMonth, NcDayConstants dayOfWeek, int dayOfWeekInMonth, NcMonthConstants monthOfYear, int repeatInterval, TimeZone tz) {
        super(scheduleType, startDate, endDate, repeatForever, isValidSchedule, useDayNumber, dayOfMonth, dayOfWeek, dayOfWeekInMonth, monthOfYear, repeatInterval, tz);
    }

    public YearlySchedule(ScheduleType scheduleType, Date start, Date end, boolean repeatForever, int intervalInMonths, boolean absoluteDate, int dayOfMonth, int dayOfWeekInMonth, NcDayConstants dayOfWeek, NcMonthConstants monthOfYear, TimeZone tz) {
        super(scheduleType, start, end, repeatForever, intervalInMonths, absoluteDate, dayOfMonth, dayOfWeekInMonth, dayOfWeek, tz);
        this.m_month_of_year = monthOfYear;
        this.setEffectiveStartDate();
        if (this.getEndAt() != null) {
            if (this.getEndAt().after(this.getExecuteFirst())) {
                this.setScheduleValid(true);
            }
        } else {
            this.setScheduleValid(true);
        }
    }

    private void setEffectiveStartDate() {
        Calendar cal = this.getExecuteFirst();
        int startRangeMonth = cal.get(2);
        if (this.m_use_day_number) {
            if (startRangeMonth != this.m_month_of_year.intValue()) {
                while (startRangeMonth != this.m_month_of_year.intValue()) {
                    this.add(cal, 2, 1);
                    if (++startRangeMonth <= 11) continue;
                    startRangeMonth = 0;
                }
                if (this.m_day_of_month > cal.getActualMaximum(5)) {
                    this.set(cal, 5, cal.getActualMaximum(5));
                } else {
                    this.set(cal, 5, this.m_day_of_month);
                }
            } else {
                int startRangeDayNumber = cal.get(5);
                if (startRangeDayNumber <= this.m_day_of_month) {
                    if (this.m_day_of_month > cal.getActualMaximum(5)) {
                        this.set(cal, 5, cal.getActualMaximum(5));
                    } else {
                        this.set(cal, 5, this.m_day_of_month);
                    }
                } else {
                    this.set(cal, 5, this.m_day_of_month);
                    this.add(cal, 1, 1);
                }
            }
        } else {
            int dayOfWeekInMonth = this.m_day_of_week_in_month;
            if (startRangeMonth != this.m_month_of_year.intValue()) {
                while (startRangeMonth != this.m_month_of_year.intValue()) {
                    this.add(cal, 2, 1);
                    if (++startRangeMonth <= 11) continue;
                    startRangeMonth = 0;
                }
                if (this.m_day_of_week_in_month > cal.getActualMaximum(8)) {
                    dayOfWeekInMonth = cal.getActualMaximum(8);
                }
                int[] fields = new int[]{7, 8};
                int[] values = new int[]{this.m_day_of_week.intValue(), dayOfWeekInMonth};
                this.set(cal, fields, values);
            } else {
                cal.clear(5);
                cal.clear(5);
                cal.clear(7);
                cal.clear(8);
                cal.clear(6);
                int[] fields = new int[]{7, 8};
                int[] values = new int[]{this.m_day_of_week.intValue(), this.m_day_of_week_in_month};
                this.set(cal, fields, values);
                if (cal.getTime().before(this.getStartDate())) {
                    this.add(cal, 1, 1);
                    fields = new int[]{7, 8};
                    values = new int[]{this.m_day_of_week.intValue(), this.m_day_of_week_in_month};
                    this.set(cal, fields, values);
                }
            }
        }
        this.setStartDate(cal.getTime());
    }

    @Override
    public String getGeneratedDescription(DateTimeFormat dateFormatter, DateTimeFormat timeFormatter) {
        String startDateString = this.getStartDateString(dateFormatter);
        String startTimeString = this.getStartTimeString(timeFormatter);
        String endDateString = this.m_repeat_forever ? "" : this.getEndDateString(dateFormatter);
        String description = null;
        String stringMonthOfYear = this.m_month_of_year.toString();
        if (this.m_use_day_number) {
            description = "Run at " + startTimeString + " on " + stringMonthOfYear + " " + this.m_day_of_month + " effective " + startDateString + endDateString;
        } else {
            String stringDayOfWeekInMonth = this.ordinalDayOfWeekInMonth(this.m_day_of_week_in_month);
            String stringWeekDay = this.m_day_of_week.toString();
            description = "Run at " + startTimeString + " on the " + stringDayOfWeekInMonth + " " + stringWeekDay + " of every " + stringMonthOfYear + " effective " + startDateString + endDateString;
        }
        return description + "\n" + this.getTimeZone().getID();
    }
}

