/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services;

import com.cognos.ems.EventManagementCategory;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import noticecast.property.IPropertiesManager;
import noticecast.services.types.BasicServiceType;
import noticecast.starter.ProcessType;
import noticecast.starter.ServiceNotAvailableException;
import noticecast.starter.SingletonServiceProvider;

public final class LocalServices {
    private static IPropertiesManager mPropsMgr = null;
    private static TimeZone mTimeZone = null;
    private static ClassLoader mNCRootLoader = null;
    private static ProcessType mProcessType = null;

    public static void setLoggingTimezone(TimeZone timeZone) {
        mTimeZone = timeZone;
    }

    public static TimeZone getLoggingTimezone() {
        if (mTimeZone == null) {
            mTimeZone = TimeZone.getTimeZone((String)"GMT");
        }
        return mTimeZone;
    }

    public static ClassLoader getNCRootLoader() {
        if (mNCRootLoader != null) {
            return mNCRootLoader;
        }
        ClassLoader result = null;
        boolean useCanonical = true;
        String rootDir = LocalServices.getPropertiesManager().getNCRoot();
        File dir = new File(rootDir);
        try {
            dir = dir.getCanonicalFile();
        }
        catch (Throwable e) {
            useCanonical = false;
        }
        if (useCanonical) {
            try {
                URL directory = dir.toURL();
                URL[] classPath = new URL[]{directory};
                result = new URLClassLoader(classPath);
            }
            catch (MalformedURLException ex) {
                String errMsg = "failed to use path " + rootDir;
                AuditProperties ap = AuditPropUtil.doProps(LocalServices.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_CONFIG_PROPERTY_EXCP, (Object[])new String[]{dir.toString()}, (Map)ap);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{errMsg + ex.getMessage()}, (Map)ap);
            }
        }
        if (result == null) {
            try {
                result = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mNCRootLoader = result;
        return mNCRootLoader;
    }

    public static String getServiceUrl() {
        String serviceUrl = null;
        try {
            String rmiPort;
            String rmiServiceName;
            String rmiHost = LocalServices.getPropertiesManager().getProperty("noticecast.rmi.host");
            if (rmiHost == null || rmiHost.trim().length() < 1) {
                rmiHost = "localhost";
                String warnMsg = "noticecast.rmi.host is not defined, using " + rmiHost;
                AuditProperties ap = AuditPropUtil.doProps(LocalServices.class, (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.OTH_NO_HOST, (Map)ap);
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(warnMsg);
            }
            if ((rmiServiceName = LocalServices.getPropertiesManager().getProperty("noticecast.rmi.service")) == null || rmiServiceName.length() < 1) {
                String errMsg = "Property noticecast.rmi.service is not defined";
                LocalServices.exitWithError(errMsg);
            }
            if ((rmiPort = LocalServices.getPropertiesManager().getProperty("noticecast.rmi.port")) == null || rmiPort.length() < 1) {
                rmiPort = "1099";
                String warnMsg = "noticecast.rmi.port is not defined, using " + rmiPort;
                AuditProperties ap = AuditPropUtil.doProps(LocalServices.class, (String)"Warning");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_NO_PORTS_SPECIFIED_FOR_SERVER_TO_BIND_TO, (Map)ap);
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(warnMsg);
            }
            serviceUrl = "rmi://" + rmiHost + ':' + rmiPort + '/' + rmiServiceName;
        }
        catch (PropertiesException ex) {
            String errMsg = "Could not read the properties";
            ex.printStackTrace(System.err);
            LocalServices.exitWithError(errMsg);
        }
        return serviceUrl;
    }

    public static void exitWithError(String errMsg) {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(errMsg);
        throw new RuntimeException(errMsg);
    }

    public static void exitWithError(String errMsg, int errCode) {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(errMsg);
        throw new RuntimeException("[" + errCode + "] " + errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final IPropertiesManager getPropertiesManager() {
        if (null != mPropsMgr) return mPropsMgr;
        Class<LocalServices> clazz = LocalServices.class;
        synchronized (LocalServices.class) {
            if (null != mPropsMgr) return mPropsMgr;
            try {
                mPropsMgr = (IPropertiesManager)SingletonServiceProvider.getInstance().getService(BasicServiceType.ConfigParserType);
            }
            catch (ServiceNotAvailableException ex) {
                ex.printStackTrace(System.err);
            }
            return mPropsMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessType getProcessType() {
        if (null != mProcessType) return mProcessType;
        Class<LocalServices> clazz = LocalServices.class;
        synchronized (LocalServices.class) {
            if (null != mProcessType) return mProcessType;
            mProcessType = SingletonServiceProvider.getInstance().getProcessType();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mProcessType;
        }
    }
}

