/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services;

import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Map;
import java.util.Properties;
import noticecast.exceptions.NCException;
import noticecast.services.IRepositoryServices;
import noticecast.services.LocalServices;
import noticecast.services.NCStreamListener;
import noticecast.services.RepositoryServicesImpl;
import noticecast.starter.ProcessType;
import noticecast.starter.SingletonServiceProvider;
import noticecast.starter.StartupException;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class NCRepositoryServer {
    private static final String successMsg = "Added remote object to the registry - ready for connections";

    private NCRepositoryServer() {
    }

    public static void main(String[] argv) {
        NCRepositoryServer.startRepository();
        try {
            SignalHandler jvmSignalHandler = new SignalHandler(){

                @Override
                public void handle(Signal sig) {
                }
            };
            Signal.handle(new Signal("HUP"), jvmSignalHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initRepositoryServices() {
        try {
            SingletonServiceProvider.getInstance().initServices(ProcessType.RepositoryServer);
        }
        catch (StartupException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug((Throwable)ex);
        }
    }

    public static final void startRepository() {
        AuditProperties ap;
        NCRepositoryServer.initRepositoryServices();
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                }
            });
        }
        catch (Throwable ex) {
            String s = "You must be running java version 1.3 to ensure optimal performance and stability. Your version is " + System.getProperty("java.class.version");
            ap = AuditPropUtil.doProps(NCRepositoryServer.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_THROWABLE_ERROR, (Object[])new String[]{s}, (Map)ap);
        }
        Thread istreamListener = new Thread(new NCStreamListener());
        istreamListener.start();
        NCRepositoryServer repositoryServer = new NCRepositoryServer();
        repositoryServer.initServices();
        ap = AuditPropUtil.doProps(NCRepositoryServer.class, (String)"Success");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, (Object[])new String[]{successMsg}, (Map)ap);
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, (Object[])new String[]{"Cognos Noticecast Server Started"}, (Map)ap);
    }

    public static final void stopRepository() {
        NCRepositoryServer.initRepositoryServices();
        String serviceName = "";
        String errMsg = "An error occurred while attemping to stop the Cognos Noticecast server ";
        serviceName = LocalServices.getServiceUrl();
        String s = "Cognos Noticecast Server is to be Stopped using " + serviceName;
        AuditProperties ap = AuditPropUtil.doProps(NCRepositoryServer.class, (String)AuditStatus.BLANK);
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, (Object[])new String[]{s}, (Map)ap);
    }

    private synchronized void initServices() {
        LocalServices.setLoggingTimezone(TimeZone.getDefault());
        Properties systemProperties = System.getProperties();
        TimeZone GMT_timeZone = TimeZone.getTimeZone((String)"GMT");
        systemProperties.put("user.timezone", GMT_timeZone.getID());
        IRepositoryServices rs = RepositoryServicesImpl.instance();
        rs.getRunTimeManager().loadSchedules();
        rs.getSchedulerController().startScheduler();
        AuditProperties ap = AuditPropUtil.doProps(NCRepositoryServer.class, (String)"Success");
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.SCHD_START_KEYWORD, (Map)ap);
    }

    public class RmiNotAvailableException
    extends NCException {
        public RmiNotAvailableException(I18NCode code, Object[] params) {
            super(code, params);
        }

        public RmiNotAvailableException(String message) {
            this(I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{"[OLD SDS CODE]" + message});
        }
    }
}

