/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services;

import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.persist.PersistManagerImpl;
import noticecast.runtime.IRunTimeManager;
import noticecast.scheduling.core.ISchedulerController;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.nc.IScheduleFactory;
import noticecast.services.IRepositoryServices;
import noticecast.services.LocalServices;
import noticecast.services.RunTimeServicesImpl;

public class RepositoryServicesImpl
implements IRepositoryServices {
    private static ThreadLocal mInitHolder = new ThreadLocal();
    private static RepositoryServicesImpl mInstance = null;
    private IPersistManager m_localPM = null;

    private RepositoryServicesImpl() {
    }

    private void initialise() {
        try {
            this.m_localPM = new PersistManagerImpl();
        }
        catch (PersistManagerException ex) {
            String errMsg = "Failed to generate persist manager";
            ex.printStackTrace(System.err);
            LocalServices.exitWithError(errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRepositoryServices instance() {
        if (mInitHolder.get() != null) return mInstance;
        Class<RepositoryServicesImpl> clazz = RepositoryServicesImpl.class;
        synchronized (RepositoryServicesImpl.class) {
            if (mInstance == null) {
                RepositoryServicesImpl theInstance = new RepositoryServicesImpl();
                theInstance.initialise();
                mInstance = theInstance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            mInitHolder.set(Boolean.TRUE);
            return mInstance;
        }
    }

    @Override
    public IPersistManager getPersistManager() {
        if (this.m_localPM == null) {
            String errMsg = "Persist manager is not available anymore";
            LocalServices.exitWithError(errMsg);
        }
        return this.m_localPM;
    }

    @Override
    public Scheduler getScheduler() {
        return RunTimeServicesImpl.instance().getScheduler();
    }

    @Override
    public ISchedulerController getSchedulerController() {
        return RunTimeServicesImpl.instance().getSchedulerController();
    }

    @Override
    public IScheduleFactory getScheduleFactory() {
        return RunTimeServicesImpl.instance().getScheduleFactory();
    }

    @Override
    public IRunTimeManager getRunTimeManager() {
        return RunTimeServicesImpl.instance().getRunTimeManager();
    }
}

