/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services;

import noticecast.runtime.IRunTimeManager;
import noticecast.runtime.RunTimeManager;
import noticecast.scheduling.core.ISchedulerController;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.core.SchedulerControllerImpl;
import noticecast.scheduling.nc.IScheduleFactory;
import noticecast.scheduling.nc.ScheduleFactoryImpl;
import noticecast.services.IRuntimeServices;

public final class RunTimeServicesImpl
implements IRuntimeServices {
    private static IRuntimeServices mInstance = null;
    private Scheduler mScheduler = null;
    private ISchedulerController mSchedulerController = null;
    private IScheduleFactory mScheduleFactory = null;
    private IRunTimeManager mRunTimeManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final IRuntimeServices instance() {
        if (mInstance != null) return mInstance;
        Class<RunTimeServicesImpl> clazz = RunTimeServicesImpl.class;
        synchronized (RunTimeServicesImpl.class) {
            if (mInstance != null) return mInstance;
            RunTimeServicesImpl service = new RunTimeServicesImpl();
            service.init();
            mInstance = service;
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private RunTimeServicesImpl() {
    }

    private void init() {
        this.mScheduler = Scheduler.getInstance();
        this.mSchedulerController = new SchedulerControllerImpl(this.mScheduler);
        this.mScheduleFactory = ScheduleFactoryImpl.getInstance();
        this.mRunTimeManager = RunTimeManager.getInstance();
    }

    @Override
    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    @Override
    public ISchedulerController getSchedulerController() {
        return this.mSchedulerController;
    }

    @Override
    public IScheduleFactory getScheduleFactory() {
        return this.mScheduleFactory;
    }

    @Override
    public IRunTimeManager getRunTimeManager() {
        return this.mRunTimeManager;
    }
}

