/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services;

import noticecast.services.CR1DeliveryServicesBuilderImpl;
import noticecast.services.CR1JobServicesBuilderImpl;
import noticecast.services.CR1SchedulerServicesBuilderImpl;
import noticecast.services.GenericServicesBuilderImpl;
import noticecast.services.RepositoryServicesBuilderImpl;
import noticecast.starter.IBuilderCreator;
import noticecast.starter.IServicesDirector;
import noticecast.starter.ProcessType;
import noticecast.starter.SchedulerServicesDirectorImpl;
import noticecast.starter.ServicesBuilder;
import noticecast.starter.ServicesDirectorImpl;

public final class ServicesBuilderCreatorImpl
implements IBuilderCreator {
    private ServicesBuilder m_services_builder;
    private IServicesDirector m_servcices_director;

    @Override
    public ServicesBuilder createServicesBuilder() {
        return this.m_services_builder;
    }

    @Override
    public IServicesDirector createDirector() {
        return this.m_servcices_director;
    }

    private ServicesBuilderCreatorImpl(ServicesBuilder services_builder, IServicesDirector servcices_director) {
        this.m_services_builder = services_builder;
        this.m_servcices_director = servcices_director;
    }

    public static IBuilderCreator getRepositoryBuildorCreator(ProcessType type) {
        ServicesBuilderCreatorImpl builder_creator = null;
        if (ProcessType.RepositoryServer.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new RepositoryServicesBuilderImpl(), new ServicesDirectorImpl());
        } else if (ProcessType.UNKNOWN.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new GenericServicesBuilderImpl(), new ServicesDirectorImpl());
        } else if (ProcessType.CR1_delivery.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new CR1DeliveryServicesBuilderImpl(), new SchedulerServicesDirectorImpl());
        } else if (ProcessType.CR1_scheduler.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new CR1SchedulerServicesBuilderImpl(), new SchedulerServicesDirectorImpl());
        } else if (ProcessType.CR1_jobservice.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new CR1JobServicesBuilderImpl(), new SchedulerServicesDirectorImpl());
        } else if (ProcessType.AdminGui.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new GenericServicesBuilderImpl(), new ServicesDirectorImpl());
        } else if (ProcessType.Administration.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new GenericServicesBuilderImpl(), new ServicesDirectorImpl());
        } else if (ProcessType.ServerController.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new GenericServicesBuilderImpl(false), new ServicesDirectorImpl());
        } else if (ProcessType.DBType.equals(type)) {
            builder_creator = new ServicesBuilderCreatorImpl(new GenericServicesBuilderImpl(), new ServicesDirectorImpl());
        }
        return builder_creator;
    }
}

