/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services.soap.cm;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.Iterator;
import java.util.Locale;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;

public class CMAssistor {
    private static final String m_MESSAGE_STUB1 = "<jsum:jobSummary xmlns:jsum='http://developer.cognos.com/schemas/bibus/3/' xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:bus='http://developer.cognos.com/schemas/bibus/3/' xsi:type='jsum:jobSummary'><executionError xsi:type='jsum:executionError'><messages xsi:type='SOAP-ENC:Array' SOAP-ENC:arrayType='bus:message[1]'><item xsi:type='bus:message'><messageString xsi:type='xsd:string'>";
    private static final String m_MESSAGE_STUB2 = "</messageString></item></messages></executionError><stepSummaries xsi:type='jsum:stepSummaries' SOAP-ENC:arrayType='jsum:stepSummary[0]'/></jsum:jobSummary>";

    public String getUserName(Account account) {
        String temp;
        String username = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, (Locale)SDSLogger.getLocale());
        StringProp user_prop = account != null ? account.getUserName() : null;
        TokenProp name_prop = account != null ? account.getDefaultName() : null;
        String string = temp = name_prop != null ? name_prop.getValue() : null;
        temp = temp != null ? temp : (user_prop != null ? user_prop.getValue() : null);
        username = temp != null ? temp : username;
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserPath(BiBusHeader header) {
        String path = null;
        String credPath = header.getCAM() != null ? header.getCAM().getCAMCredentialPath() : null;
        ContentManagerServiceClientPort cm = null;
        try {
            BaseClass[] classes;
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            if (credPath != null) {
                AuthenticatorFactory.getInstance().logon(headers);
            }
            if ((classes = (cm = Client.instance().getContentManagerServiceClient(headers)).query(new SearchPathMultipleObject("~"), new PropEnum[]{PropEnum.searchPath}, new Sort[0], new QueryOptions())) != null && classes.length >= 1) {
                StringProp prop = classes[0] != null ? ((Account)classes[0]).getSearchPath() : null;
                path = prop != null ? prop.getValue() : path;
            } else {
                path = "";
            }
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        return path;
    }

    private String getTaskCredential(ITask task) {
        String credential_blob = null;
        Iterator itr = task.getMessages();
        while (itr.hasNext()) {
            IMessageStruct message = (IMessageStruct)itr.next();
            credential_blob = message.getCredential();
        }
        String credential = "";
        if (credential_blob != null) {
            int path_index = credential_blob.indexOf("searchPath");
            if (path_index != -1) {
                int value_index = credential_blob.indexOf("value", path_index);
                int gt_index = credential_blob.indexOf(62, value_index);
                int lt_index = credential_blob.indexOf(60, gt_index);
                credential = credential_blob.substring(gt_index + 1, lt_index);
            } else {
                credential = credential_blob;
            }
        }
        return credential;
    }

    private AnyTypeProp makeFaultProp(String username, Locale currentProductLocale) {
        AnyTypeProp type_prop = new AnyTypeProp();
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_JOB_WAS_CANCELLED_BY_USER_X, (Object[])new String[]{username});
        String value = "<jsum:jobSummary xmlns:jsum='http://developer.cognos.com/schemas/bibus/3/' xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:bus='http://developer.cognos.com/schemas/bibus/3/' xsi:type='jsum:jobSummary'><executionError xsi:type='jsum:executionError'><messages xsi:type='SOAP-ENC:Array' SOAP-ENC:arrayType='bus:message[1]'><item xsi:type='bus:message'><messageString xsi:type='xsd:string'> " + I18NUtil.getMessage((I18NCode)I18NCode.MSG_JOB_WAS_CANCELLED_BY_USER_X, (Object[])new Object[]{username}, (Locale)LocaleUtil.createProductLocale((String)currentProductLocale.toString())) + " " + m_MESSAGE_STUB2;
        type_prop.setValue(value);
        return type_prop;
    }
}

