/*
 * Decompiled with CFR 0.152.
 */
package noticecast.services.soap.cm;

import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageLine;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.TextMessageLine;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.services.RepositoryServicesImpl;
import org.dom4j.Element;
import org.dom4j.Node;

public class CMRunnablePathResolver {
    private CMRunnablePathResolver() {
    }

    public static String getRunnablePath(NCObjectId task_id) {
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        ITask task = null;
        try {
            task = (ITask)pm.findNCObjectConsumerCopyByOid(task_id, NCObjectType.TASK);
        }
        catch (PersistManagerException ex) {
            return null;
        }
        if (task == null) {
            return null;
        }
        IMessageStruct ms = null;
        Iterator messagesIter = task.getMessages();
        if (messagesIter.hasNext()) {
            ms = (IMessageStruct)messagesIter.next();
        }
        Iterator linesIter = ms.getMessageLines().iterator();
        StringBuffer buffer = new StringBuffer();
        while (linesIter.hasNext()) {
            IMessageLine line = (IMessageLine)linesIter.next();
            if (!(line instanceof TextMessageLine)) continue;
            buffer.append(line.toString());
        }
        String runnablePath = CMRunnablePathResolver.extractRunnablePath(buffer.toString());
        return runnablePath;
    }

    private static String extractRunnablePath(String jobRunInfo) {
        String path = null;
        try {
            StringReader reader = new StringReader(jobRunInfo);
            BIBusEnvelope env = new BIBusEnvelope((Reader)reader);
            Element body = env.getEnvelope();
            Element body2 = env.getBody();
            Node path_node = body.selectSingleNode("./*[local-name()='submit']/*[local-name()='obj']");
            if (path_node == null) {
                path_node = body2.selectSingleNode("./*[local-name()='submit']/*[local-name()='obj']");
            }
            if (path_node == null) {
                path_node = body2.selectSingleNode("./*[local-name()='runAt']/*[local-name()='objectPath']");
            }
            if (path_node == null) {
                path_node = body.selectSingleNode("./*[local-name()='runAt']/*[local-name()='objectPath']");
            }
            if (path_node == null) {
                path_node = body.selectSingleNode("./*[local-name()='submitAt']/*[local-name()='obj']");
            }
            if (path_node == null) {
                path_node = body2.selectSingleNode("./*[local-name()='submitAt']/*[local-name()='obj']");
            }
            if (path_node != null) {
                path = path_node.getText();
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return path;
    }
}

