/*
 * Decompiled with CFR 0.152.
 */
package noticecast.starter;

import com.cognos.jsmcommon.i18n.I18NCode;
import java.util.Hashtable;
import noticecast.services.ServicesBuilderCreatorImpl;
import noticecast.starter.BasicType;
import noticecast.starter.IBuilderCreator;
import noticecast.starter.IServicesDirector;
import noticecast.starter.ProcessType;
import noticecast.starter.ServiceNotAvailableException;
import noticecast.starter.ServicesBuilder;

public final class SingletonServiceProvider {
    private Hashtable m_services = new Hashtable();
    private ProcessType m_processType;
    private static SingletonServiceProvider m_instance = null;

    private SingletonServiceProvider() {
    }

    public Object getService(BasicType type) throws ServiceNotAvailableException {
        if (!this.m_services.containsKey(type)) {
            throw new ServiceNotAvailableException(I18NCode.MSG_SERVICE_CALL_IS_INVALID_OR_NOT_SUPPORTED);
        }
        return this.m_services.get(type);
    }

    public boolean hasService(BasicType type) {
        return this.m_services.containsKey(type);
    }

    public void setService(Object service, BasicType type) {
        if (this.m_services.contains(type)) {
            return;
        }
        this.m_services.put(type, service);
    }

    public void initServices(ProcessType processType) {
        IBuilderCreator builder_creator = ServicesBuilderCreatorImpl.getRepositoryBuildorCreator(processType);
        ServicesBuilder builder = builder_creator.createServicesBuilder();
        IServicesDirector director = builder_creator.createDirector();
        this.initServices(director, builder, processType);
    }

    public void initServices(IServicesDirector director, ServicesBuilder builder, ProcessType processType) {
        ProcessType processType2 = processType = processType == null ? ProcessType.UNKNOWN : processType;
        if (processType.canUpgrade(this.m_processType)) {
            this.m_processType = processType;
        }
        director.prepareServices(builder);
    }

    public ProcessType getProcessType() {
        return this.m_processType;
    }

    public void setProcessType(ProcessType type) {
        this.m_processType = type;
    }

    public static synchronized SingletonServiceProvider getInstance() {
        if (m_instance == null) {
            m_instance = new SingletonServiceProvider();
        }
        return m_instance;
    }
}

