/*
 * Decompiled with CFR 0.152.
 */
package noticecast.util;

import java.io.Serializable;
import java.util.Hashtable;
import noticecast.starter.SingletonServiceProvider;

public class NcDayConstants
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private static final int m_sunday = 1;
    private static final int m_monday = 2;
    private static final int m_tuesday = 3;
    private static final int m_wednesday = 4;
    private static final int m_thursday = 5;
    private static final int m_friday = 6;
    private static final int m_saturday = 7;
    private static final String m_sundayString = "sun";
    private static final String m_mondayString = "mon";
    private static final String m_tuesdayString = "tue";
    private static final String m_wednesdayString = "wed";
    private static final String m_thursdayString = "thu";
    private static final String m_fridayString = "fri";
    private static final String m_saturdayString = "sat";
    private static final String m_baltic_sundayString = "sunday";
    private static final String m_baltic_mondayString = "monday";
    private static final String m_baltic_tuesdayString = "tuesday";
    private static final String m_baltic_wednesdayString = "wednesday";
    private static final String m_baltic_thursdayString = "thursday";
    private static final String m_baltic_fridayString = "friday";
    private static final String m_baltic_saturdayString = "saturday";
    private Integer m_day_int;
    private String m_day_string;
    private static Hashtable dayMap;
    private static Hashtable balticDayStrings;
    public static NcDayConstants SUNDAY;
    public static NcDayConstants MONDAY;
    public static NcDayConstants TUESDAY;
    public static NcDayConstants WEDNESDAY;
    public static NcDayConstants THURSDAY;
    public static NcDayConstants FRIDAY;
    public static NcDayConstants SATURDAY;
    public static NcDayConstants[] DAYS;

    private NcDayConstants(int index, String day) {
        this.m_day_int = new Integer(index);
        this.m_day_string = day;
        if (dayMap == null) {
            dayMap = new Hashtable();
        }
        dayMap.put(this.m_day_string, this.m_day_int);
    }

    public static NcDayConstants getDay(int value) {
        switch (value) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        return null;
    }

    public int intValue() {
        return this.m_day_int;
    }

    public String stringValue() {
        return this.m_day_string;
    }

    public static NcDayConstants getDay(String key) {
        if (dayMap == null || key == null) {
            return null;
        }
        Integer I = (Integer)dayMap.get(key);
        if (I == null && (key = (String)balticDayStrings.get(key)) != null) {
            I = (Integer)dayMap.get(key);
        }
        if (I != null) {
            return NcDayConstants.getDay(I);
        }
        return null;
    }

    public static String getStringValue(int index) {
        String value = null;
        if (SingletonServiceProvider.getInstance().getProcessType().isBaltic()) {
            switch (index) {
                case 1: {
                    value = m_baltic_sundayString;
                    break;
                }
                case 2: {
                    value = m_baltic_mondayString;
                    break;
                }
                case 3: {
                    value = m_baltic_tuesdayString;
                    break;
                }
                case 4: {
                    value = m_baltic_wednesdayString;
                    break;
                }
                case 5: {
                    value = m_baltic_thursdayString;
                    break;
                }
                case 6: {
                    value = m_baltic_fridayString;
                    break;
                }
                case 7: {
                    value = m_baltic_saturdayString;
                }
            }
        } else {
            switch (index) {
                case 1: {
                    value = m_sundayString;
                    break;
                }
                case 2: {
                    value = m_mondayString;
                    break;
                }
                case 3: {
                    value = m_tuesdayString;
                    break;
                }
                case 4: {
                    value = m_wednesdayString;
                    break;
                }
                case 5: {
                    value = m_thursdayString;
                    break;
                }
                case 6: {
                    value = m_fridayString;
                    break;
                }
                case 7: {
                    value = m_saturdayString;
                }
            }
        }
        return value;
    }

    public String toString() {
        return NcDayConstants.getLongStringValue(this.intValue());
    }

    public static String getLongStringValue(int index) {
        String value = null;
        switch (index) {
            case 1: {
                value = "Sunday";
                break;
            }
            case 2: {
                value = "Monday";
                break;
            }
            case 3: {
                value = "Tuesday";
                break;
            }
            case 4: {
                value = "Wednesday";
                break;
            }
            case 5: {
                value = "Thursday";
                break;
            }
            case 6: {
                value = "Friday";
                break;
            }
            case 7: {
                value = "Saturday";
            }
        }
        return value;
    }

    public boolean equals(Object obj) {
        boolean isEqual = null != obj;
        boolean bl = isEqual = isEqual && obj instanceof NcDayConstants;
        if (isEqual) {
            Integer theOtherValue = ((NcDayConstants)obj).m_day_int;
            isEqual = isEqual && this.m_day_int.equals(theOtherValue);
        }
        return isEqual;
    }

    public int hashCode() {
        return this.m_day_int;
    }

    static {
        balticDayStrings = new Hashtable();
        balticDayStrings.put(m_baltic_sundayString, m_sundayString);
        balticDayStrings.put(m_baltic_mondayString, m_mondayString);
        balticDayStrings.put(m_baltic_tuesdayString, m_tuesdayString);
        balticDayStrings.put(m_baltic_wednesdayString, m_wednesdayString);
        balticDayStrings.put(m_baltic_thursdayString, m_thursdayString);
        balticDayStrings.put(m_baltic_fridayString, m_fridayString);
        balticDayStrings.put(m_baltic_saturdayString, m_saturdayString);
        SUNDAY = new NcDayConstants(1, m_sundayString);
        MONDAY = new NcDayConstants(2, m_mondayString);
        TUESDAY = new NcDayConstants(3, m_tuesdayString);
        WEDNESDAY = new NcDayConstants(4, m_wednesdayString);
        THURSDAY = new NcDayConstants(5, m_thursdayString);
        FRIDAY = new NcDayConstants(6, m_fridayString);
        SATURDAY = new NcDayConstants(7, m_saturdayString);
        DAYS = new NcDayConstants[]{SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};
    }
}

