/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.command;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.command.Command;
import org.odata4j.command.CommandContext;
import org.odata4j.command.CommandResult;
import org.odata4j.command.FilterCommand;
import org.odata4j.command.FilterResult;
import org.odata4j.core.UmbrellaException;

public class ChainCommand<TContext extends CommandContext>
implements Command<TContext> {
    private final List<Command<TContext>> commands;

    public static <TContext extends CommandContext> Builder<TContext> newBuilder() {
        return new Builder();
    }

    public ChainCommand(List<Command<TContext>> commands) {
        this.commands = commands;
    }

    @Override
    public CommandResult execute(TContext context) throws Exception {
        CommandResult commandResult = null;
        Exception executionException = null;
        int i = 0;
        int n = this.commands.size();
        for (i = 0; i < n; ++i) {
            try {
                commandResult = this.commands.get(i).execute(context);
                if (commandResult != CommandResult.COMPLETE) continue;
                break;
            }
            catch (Exception e) {
                executionException = e;
            }
        }
        if (i >= n) {
            --i;
        }
        boolean executionExceptionHandled = false;
        ArrayList<Exception> postProcessExceptions = null;
        for (int j = i; j >= 0; --j) {
            if (!(this.commands.get(j) instanceof FilterCommand)) continue;
            FilterCommand filterCommand = (FilterCommand)this.commands.get(j);
            try {
                FilterResult postProcessResult = filterCommand.postProcess(context, executionException);
                if (postProcessResult != FilterResult.HANDLED) continue;
                executionExceptionHandled = true;
                continue;
            }
            catch (Exception e) {
                if (postProcessExceptions == null) {
                    postProcessExceptions = new ArrayList<Exception>();
                }
                postProcessExceptions.add(e);
            }
        }
        if (postProcessExceptions != null) {
            throw new UmbrellaException(postProcessExceptions);
        }
        if (executionException != null && !executionExceptionHandled) {
            throw executionException;
        }
        return commandResult;
    }

    public static class Builder<TContext extends CommandContext> {
        private final List<Command<TContext>> commands = new ArrayList<Command<TContext>>();

        public Builder<TContext> add(Command<?> command) {
            if (command != null) {
                this.commands.add(command);
            }
            return this;
        }

        public Builder<TContext> addAll(Iterable<Command<?>> commands) {
            if (commands != null) {
                for (Command<?> command : commands) {
                    this.add(command);
                }
            }
            return this;
        }

        public ChainCommand<TContext> build() {
            return new ChainCommand<TContext>(this.commands);
        }
    }
}

