/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.AbstractConsumerEntityRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.OEntityGetRequest;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.Settings;
import org.odata4j.internal.EntitySegment;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;

public class ConsumerGetEntityRequest<T>
extends AbstractConsumerEntityRequest<T>
implements OEntityGetRequest<T> {
    private final Class<T> entityType;
    private final FeedCustomizationMapping fcMapping;
    private String select;
    private String expand;

    public ConsumerGetEntityRequest(ODataClient client, Class<T> entityType, String serviceRootUri, EdmDataServices metadata, String entitySetName, OEntityKey key, FeedCustomizationMapping fcMapping) {
        super(client, serviceRootUri, metadata, entitySetName, key);
        this.entityType = entityType;
        this.fcMapping = fcMapping;
    }

    @Override
    public ConsumerGetEntityRequest<T> select(String select) {
        this.select = select;
        return this;
    }

    @Override
    public ConsumerGetEntityRequest<T> expand(String expand) {
        this.expand = expand;
        return this;
    }

    @Override
    public T execute() throws ODataProducerException {
        ODataClientResponse response;
        String path = Enumerable.create(this.getSegments()).join("/");
        ODataClientRequest request = ODataClientRequest.get(this.getServiceRootUri() + path);
        if (this.select != null) {
            request = request.queryParam("$select", this.select);
        }
        if (this.expand != null) {
            request = request.queryParam("$expand", this.expand);
        }
        if ((response = this.getClient().getEntity(request)) == null) {
            return null;
        }
        EdmEntitySet entitySet = this.getMetadata().getEdmEntitySet(this.getSegments().get((int)0).segment);
        for (EntitySegment segment : this.getSegments().subList(1, this.getSegments().size())) {
            EdmNavigationProperty navProperty = entitySet.getType().findNavigationProperty(segment.segment);
            entitySet = this.getMetadata().getEdmEntitySet(navProperty.getToRole().getType());
        }
        OEntityKey key = Enumerable.create(this.getSegments()).last().key;
        FormatParser<Feed> parser = FormatParserFactory.getParser(Feed.class, this.getClient().getFormatType(), new Settings(ODataConstants.DATA_SERVICE_VERSION, this.getMetadata(), entitySet.getName(), key, this.fcMapping));
        Entry entry = Enumerable.create(parser.parse(this.getClient().getFeedReader(response)).getEntries()).firstOrNull();
        response.close();
        return InternalUtil.toEntity(this.entityType, entry.getEntity());
    }
}

