/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.net.URLDecoder;
import java.util.Iterator;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.ReadOnlyIterator;
import org.odata4j.consumer.AbstractConsumerQueryRequestBase;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.core.ODataVersion;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.Settings;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;

public class ConsumerQueryEntitiesRequest<T>
extends AbstractConsumerQueryRequestBase<T> {
    private final Class<T> entityType;
    private final FeedCustomizationMapping fcMapping;

    public ConsumerQueryEntitiesRequest(ODataClient client, Class<T> entityType, String serviceRootUri, EdmDataServices metadata, String entitySetName, FeedCustomizationMapping fcMapping) {
        super(client, serviceRootUri, metadata, entitySetName);
        this.entityType = entityType;
        this.fcMapping = fcMapping;
    }

    @Override
    public Enumerable<T> execute() throws ODataProducerException {
        ODataClientRequest request = this.buildRequest(null);
        Enumerable<Entry> entries = this.getEntries(request);
        return entries.select(new Func1<Entry, T>(){

            @Override
            public T apply(Entry input) {
                return InternalUtil.toEntity(ConsumerQueryEntitiesRequest.this.entityType, input.getEntity());
            }
        }).cast(this.entityType);
    }

    private Enumerable<Entry> getEntries(final ODataClientRequest request) throws ODataProducerException {
        final Feed feed = this.doRequest(request);
        return Enumerable.createFromIterator(new Func<Iterator<Entry>>(){

            @Override
            public Iterator<Entry> apply() {
                return new EntryIterator(request, feed);
            }
        });
    }

    private Feed doRequest(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.getClient().getEntities(request);
        ODataVersion version = InternalUtil.getDataServiceVersion(response.getHeaders().getFirst("DataServiceVersion"));
        FormatParser<Feed> parser = FormatParserFactory.getParser(Feed.class, this.getClient().getFormatType(), new Settings(version, this.getMetadata(), this.getEntitySet().getName(), null, this.fcMapping));
        Feed feed = parser.parse(this.getClient().getFeedReader(response));
        response.close();
        return feed;
    }

    private class EntryIterator
    extends ReadOnlyIterator<Entry> {
        private ODataClientRequest request;
        private Feed feed;
        private Iterator<Entry> feedEntries;
        private int feedEntryCount;

        public EntryIterator(ODataClientRequest request, Feed feed) {
            this.request = request;
            this.feed = feed;
            this.feedEntries = feed.getEntries().iterator();
            this.feedEntryCount = 0;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<Entry> advance() throws Exception {
            if (this.feed == null) {
                this.feed = ConsumerQueryEntitiesRequest.this.doRequest(this.request);
                this.feedEntries = this.feed.getEntries().iterator();
                this.feedEntryCount = 0;
            }
            if (this.feedEntries.hasNext()) {
                ++this.feedEntryCount;
                return ReadOnlyIterator.IterationResult.next(this.feedEntries.next());
            }
            if (this.request.getQueryParams().containsKey("$page") && this.request.getQueryParams().containsKey("$itemsPerPage")) {
                if (this.feedEntryCount == 0) {
                    return ReadOnlyIterator.IterationResult.done();
                }
                int page = Integer.parseInt(this.request.getQueryParams().get("$page"));
                this.request = this.request.queryParam("$page", Integer.toString(page + 1));
            } else {
                if (this.feed.getNext() == null) {
                    return ReadOnlyIterator.IterationResult.done();
                }
                int skipTokenIndex = this.feed.getNext().indexOf("$skiptoken=");
                if (skipTokenIndex > -1) {
                    String skiptoken = this.feed.getNext().substring(skipTokenIndex + "$skiptoken=".length());
                    skiptoken = URLDecoder.decode(skiptoken, "UTF-8");
                    this.request = this.request.queryParam("$skiptoken", skiptoken);
                } else if (this.feed.getNext().toLowerCase().startsWith("http")) {
                    this.request = ODataClientRequest.get(this.feed.getNext());
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            this.feed = null;
            return this.advance();
        }
    }
}

