/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDocumentation;

public class EdmItem {
    private final EdmDocumentation documentation;
    private final ImmutableList<? extends NamespacedAnnotation<?>> annotations;

    protected EdmItem(EdmDocumentation documentation, ImmutableList<EdmAnnotation<?>> annotations) {
        this.documentation = documentation;
        this.annotations = annotations;
    }

    public EdmDocumentation getDocumentation() {
        return this.documentation;
    }

    public Iterable<? extends NamespacedAnnotation<?>> getAnnotations() {
        return this.annotations;
    }

    public NamespacedAnnotation<?> findAnnotation(String namespaceUri, String localName) {
        if (this.annotations != null) {
            for (NamespacedAnnotation<?> annotation : this.annotations) {
                if (!annotation.getNamespace().getUri().equals(namespaceUri) || !annotation.getName().equals(localName)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static abstract class Builder<T, TBuilder> {
        private EdmDocumentation documentation;
        private List<EdmAnnotation<?>> annotations;

        abstract TBuilder newBuilder(T var1, BuilderContext var2);

        public EdmDocumentation getDocumentation() {
            return this.documentation;
        }

        public List<EdmAnnotation<?>> getAnnotations() {
            return this.annotations;
        }

        public TBuilder setDocumentation(EdmDocumentation documentation) {
            this.documentation = documentation;
            return (TBuilder)this;
        }

        public TBuilder setAnnotations(List<EdmAnnotation<?>> annotations) {
            this.annotations = annotations;
            return (TBuilder)this;
        }
    }

    static class BuilderContext {
        private final Map<Object, Builder<?, ?>> newBuilders = new HashMap();
        private final EdmDataServices.Builder dataServices;

        public BuilderContext(EdmDataServices.Builder ds) {
            this.dataServices = ds;
        }

        public EdmDataServices.Builder getDataServices() {
            return this.dataServices;
        }

        public <T, TBuilder> TBuilder newBuilder(T item, Builder<T, TBuilder> builder) {
            if (!this.newBuilders.containsKey(item)) {
                this.newBuilders.put(item, (Builder)builder.newBuilder(item, this));
            }
            return (TBuilder)this.newBuilders.get(item);
        }

        public <T, TBuilder extends Builder<?, ?>> void register(T item, TBuilder builder) {
            this.newBuilders.put(item, builder);
        }
    }
}

