/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OEntity;
import org.odata4j.core.OObject;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.exceptions.NotImplementedException;

public abstract class EdmType
extends EdmItem {
    private final String fullyQualifiedTypeName;

    protected EdmType(String fullyQualifiedTypeName) {
        this(fullyQualifiedTypeName, null, null);
    }

    protected EdmType(String fullyQualifiedTypeName, EdmDocumentation documentation, ImmutableList<EdmAnnotation<?>> annotations) {
        super(documentation, annotations);
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public static EdmSimpleType<?> getSimple(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName == null) {
            return null;
        }
        EdmSimpleType simpleType = (EdmSimpleType)LazyInit.POOL.get(fullyQualifiedTypeName);
        if (simpleType == null && !fullyQualifiedTypeName.contains(".")) {
            for (EdmSimpleType simpleTypeInPool : LazyInit.POOL.values()) {
                if (!simpleTypeInPool.getFullyQualifiedTypeName().equalsIgnoreCase("Edm." + fullyQualifiedTypeName)) continue;
                return simpleTypeInPool;
            }
        }
        return simpleType;
    }

    public static Class<? extends OObject> getInstanceType(EdmType edmType) {
        if (edmType instanceof EdmComplexType) {
            return OComplexObject.class;
        }
        if (edmType instanceof EdmCollectionType) {
            return OCollection.class;
        }
        if (edmType instanceof EdmEntityType) {
            return OEntity.class;
        }
        throw new NotImplementedException("Unable to determine instance type for edm type: " + edmType.getFullyQualifiedTypeName());
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getFullyQualifiedTypeName());
    }

    public int hashCode() {
        return this.fullyQualifiedTypeName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof EdmType && ((EdmType)other).fullyQualifiedTypeName.equals(this.fullyQualifiedTypeName);
    }

    public abstract boolean isSimple();

    public static DeferredBuilder<?, ?> newDeferredBuilder(String fqTypeName, EdmDataServices.Builder dataServices) {
        return new DeferredBuilder(fqTypeName, dataServices);
    }

    public static class DeferredBuilder<T, TBuilder>
    extends Builder<T, TBuilder> {
        private final String fqTypeName;
        private final EdmDataServices.Builder dataServices;

        private DeferredBuilder(String fqTypeName, EdmDataServices.Builder dataServices) {
            this.fqTypeName = fqTypeName;
            this.dataServices = dataServices;
        }

        @Override
        public EdmType build() {
            return this._build();
        }

        @Override
        protected EdmType buildImpl() {
            Builder<?, ?> b = this.dataServices.resolveType(this.fqTypeName);
            if (b == null) {
                throw new RuntimeException("Edm-type not found: " + this.fqTypeName);
            }
            return b.build();
        }

        @Override
        TBuilder newBuilder(Object item, EdmItem.BuilderContext context) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static abstract class Builder<T, TBuilder>
    extends EdmItem.Builder<T, TBuilder> {
        private EdmType builtType = null;

        public Builder() {
        }

        public Builder(EdmType type) {
            this.builtType = type;
        }

        public abstract EdmType build();

        protected final EdmType _build() {
            if (this.builtType == null) {
                this.builtType = this.buildImpl();
            }
            return this.builtType;
        }

        protected abstract EdmType buildImpl();
    }

    private static class LazyInit {
        private static final Map<String, EdmSimpleType<?>> POOL = Enumerable.create(EdmSimpleType.ALL).toMap(new Func1<EdmSimpleType<?>, String>(){

            @Override
            public String apply(EdmSimpleType<?> t) {
                return t.getFullyQualifiedTypeName();
            }
        });

        private LazyInit() {
        }
    }
}

