/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Response;
import org.odata4j.core.OError;
import org.odata4j.core.OErrors;

public abstract class ODataProducerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final OError error;

    protected ODataProducerException(String message, Throwable cause) {
        super(message, cause);
        this.error = OErrors.error(this.code(), this.message(), this.innerError());
    }

    protected ODataProducerException(OError error) {
        super(error.getMessage());
        this.error = error;
    }

    protected String code() {
        return this.getClass().getSimpleName();
    }

    protected String message() {
        if (this.getMessage() != null) {
            return this.getMessage();
        }
        if (this.getHttpStatus() != null) {
            return this.getHttpStatus().getReasonPhrase();
        }
        return null;
    }

    protected String innerError() {
        StringWriter sw = new StringWriter();
        this.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public abstract Response.StatusType getHttpStatus();

    public OError getOError() {
        return this.error;
    }
}

