/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.jersey.consumer;

import com.sun.jersey.core.spi.factory.AbstractRuntimeDelegate;
import com.sun.ws.rs.ext.RuntimeDelegateImpl;
import javax.ws.rs.ext.RuntimeDelegate;
import org.odata4j.consumer.AbstractODataConsumer;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.format.FormatType;
import org.odata4j.jersey.consumer.DefaultJerseyClientFactory;
import org.odata4j.jersey.consumer.JerseyClientFactory;
import org.odata4j.jersey.consumer.ODataJerseyClient;

public class ODataJerseyConsumer
extends AbstractODataConsumer {
    private ODataJerseyClient client;

    private ODataJerseyConsumer(FormatType type, String serviceRootUri, JerseyClientFactory clientFactory, OClientBehavior ... behaviors) {
        super(serviceRootUri);
        if (!(RuntimeDelegate.getInstance() instanceof AbstractRuntimeDelegate)) {
            RuntimeDelegate.setInstance(new RuntimeDelegateImpl());
        }
        this.client = new ODataJerseyClient(type, clientFactory, behaviors);
    }

    @Override
    protected ODataClient getClient() {
        return this.client;
    }

    public static Builder newBuilder(String serviceRootUri) {
        return new Builder(serviceRootUri);
    }

    public static ODataJerseyConsumer create(String serviceRootUri) {
        return ODataJerseyConsumer.newBuilder(serviceRootUri).build();
    }

    public static class Builder
    implements ODataConsumer.Builder {
        private FormatType formatType;
        private String serviceRootUri;
        private JerseyClientFactory clientFactory;
        private OClientBehavior[] clientBehaviors;

        private Builder(String serviceRootUri) {
            this.serviceRootUri = serviceRootUri;
            this.formatType = FormatType.ATOM;
            this.clientFactory = DefaultJerseyClientFactory.INSTANCE;
        }

        @Override
        public Builder setFormatType(FormatType formatType) {
            this.formatType = formatType;
            return this;
        }

        public Builder setClientFactory(JerseyClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        @Override
        public Builder setClientBehaviors(OClientBehavior ... clientBehaviors) {
            this.clientBehaviors = clientBehaviors;
            return this;
        }

        @Override
        public ODataJerseyConsumer build() {
            if (this.clientBehaviors != null) {
                return new ODataJerseyConsumer(this.formatType, this.serviceRootUri, this.clientFactory, this.clientBehaviors);
            }
            return new ODataJerseyConsumer(this.formatType, this.serviceRootUri, this.clientFactory, new OClientBehavior[0]);
        }
    }
}

