/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import java.math.BigDecimal;
import java.util.Set;
import org.core4j.Enumerable;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.expression.AddExpression;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryCommonExpression;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.CastExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.DivExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.Expression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LiteralExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.ModExpression;
import org.odata4j.expression.MulExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.SubExpression;
import org.odata4j.expression.SubstringOfMethodCallExpression;
import org.odata4j.internal.TypeConverter;

public class ExpressionEvaluator {
    private VariableResolver resolver = null;
    private static final Set<Class> SUPPORTED_CLASSES_FOR_BINARY_PROMOTION = Enumerable.create(BigDecimal.class, Double.class, Float.class, Byte.class, Integer.class, Short.class, Long.class).cast(Class.class).toSet();

    public ExpressionEvaluator(VariableResolver resolver) {
        this.resolver = resolver;
    }

    public Object evaluate(CommonExpression expression) {
        if (expression instanceof LiteralExpression) {
            return Expression.literalValue((LiteralExpression)expression);
        }
        if (expression instanceof BoolCommonExpression) {
            return this.evaluate((BoolCommonExpression)expression);
        }
        if (expression instanceof EntitySimpleProperty) {
            return this.resolver.resolveVariable(((EntitySimpleProperty)expression).getPropertyName());
        }
        if (expression instanceof AddExpression) {
            return this.binaryFunction((BinaryCommonExpression)expression, BinaryFunction.ADD);
        }
        if (expression instanceof SubExpression) {
            return this.binaryFunction((BinaryCommonExpression)expression, BinaryFunction.SUB);
        }
        if (expression instanceof MulExpression) {
            return this.binaryFunction((BinaryCommonExpression)expression, BinaryFunction.MUL);
        }
        if (expression instanceof DivExpression) {
            return this.binaryFunction((BinaryCommonExpression)expression, BinaryFunction.DIV);
        }
        if (expression instanceof ModExpression) {
            return this.binaryFunction((BinaryCommonExpression)expression, BinaryFunction.MOD);
        }
        if (expression instanceof ParenExpression) {
            return this.evaluate(((ParenExpression)expression).getExpression());
        }
        if (expression instanceof BoolParenExpression) {
            return this.evaluate(((BoolParenExpression)expression).getExpression());
        }
        if (expression instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression;
            EdmSimpleType<?> t = EdmType.getSimple(castExpression.getType());
            if (t == null) {
                throw new UnsupportedOperationException("Only simple types supported");
            }
            Class<?> javaType = t.getJavaTypes().iterator().next();
            return TypeConverter.convert(this.evaluate(castExpression.getExpression()), javaType);
        }
        throw new UnsupportedOperationException("unsupported expression " + expression);
    }

    public boolean evaluate(BoolCommonExpression expression) {
        if (expression instanceof EqExpression) {
            return this.equals((EqExpression)expression);
        }
        if (expression instanceof NeExpression) {
            return !this.equals((NeExpression)expression);
        }
        if (expression instanceof AndExpression) {
            AndExpression e = (AndExpression)expression;
            return this.evaluate(e.getLHS()) && this.evaluate(e.getRHS());
        }
        if (expression instanceof OrExpression) {
            OrExpression e = (OrExpression)expression;
            return this.evaluate(e.getLHS()) || this.evaluate(e.getRHS());
        }
        if (expression instanceof BooleanLiteral) {
            return ((BooleanLiteral)expression).getValue();
        }
        if (expression instanceof GtExpression) {
            return this.compareTo((GtExpression)expression) > 0;
        }
        if (expression instanceof LtExpression) {
            return this.compareTo((LtExpression)expression) < 0;
        }
        if (expression instanceof GeExpression) {
            return this.compareTo((GeExpression)expression) >= 0;
        }
        if (expression instanceof LeExpression) {
            return this.compareTo((LeExpression)expression) <= 0;
        }
        if (expression instanceof NotExpression) {
            NotExpression e = (NotExpression)expression;
            Boolean rt = (Boolean)this.evaluate(e.getExpression());
            return rt == false;
        }
        if (expression instanceof SubstringOfMethodCallExpression) {
            SubstringOfMethodCallExpression e = (SubstringOfMethodCallExpression)expression;
            String targetValue = (String)this.evaluate(e.getTarget());
            String searchValue = (String)this.evaluate(e.getValue());
            return targetValue != null && searchValue != null && targetValue.contains(searchValue);
        }
        if (expression instanceof ParenExpression) {
            Object obj = null;
        }
        if (expression instanceof BoolParenExpression) {
            BoolParenExpression e = (BoolParenExpression)expression;
            return this.evaluate((BoolCommonExpression)e.getExpression());
        }
        throw new UnsupportedOperationException("unsupported expression " + expression);
    }

    private Object binaryFunction(BinaryCommonExpression be, BinaryFunction function) {
        ObjectPair pair = new ObjectPair(be.getLHS(), be.getRHS());
        this.binaryNumericPromotion(pair);
        if (pair.lhs instanceof BigDecimal) {
            return function.apply((BigDecimal)pair.lhs, (BigDecimal)pair.rhs);
        }
        if (pair.lhs instanceof Double) {
            return function.apply((Double)pair.lhs, (Double)pair.rhs);
        }
        if (pair.lhs instanceof Float) {
            return function.apply((Float)pair.lhs, (Float)pair.rhs);
        }
        if (pair.lhs instanceof Integer) {
            return function.apply((Integer)pair.lhs, (Integer)pair.rhs);
        }
        if (pair.lhs instanceof Long) {
            return function.apply((Long)pair.lhs, (Long)pair.rhs);
        }
        throw new UnsupportedOperationException("unsupported add type " + pair.lhs);
    }

    private boolean equals(BinaryCommonExpression be) {
        ObjectPair pair = new ObjectPair(be.getLHS(), be.getRHS());
        this.binaryNumericPromotion(pair);
        return pair.lhs == null ? pair.rhs == null : pair.lhs.equals(pair.rhs);
    }

    private int compareTo(BinaryCommonExpression be) {
        ObjectPair pair = new ObjectPair(be.getLHS(), be.getRHS());
        this.binaryNumericPromotion(pair);
        return ((Comparable)pair.lhs).compareTo((Comparable)pair.rhs);
    }

    private void binaryNumericPromotion(ObjectPair pair) {
        Class<?> rhsClass;
        if (pair.lhs == null || pair.rhs == null) {
            return;
        }
        Class<?> lhsClass = pair.lhs.getClass();
        if (lhsClass.equals(rhsClass = pair.rhs.getClass())) {
            return;
        }
        if (!SUPPORTED_CLASSES_FOR_BINARY_PROMOTION.contains(lhsClass) || !SUPPORTED_CLASSES_FOR_BINARY_PROMOTION.contains(rhsClass)) {
            return;
        }
        if (lhsClass.equals(BigDecimal.class) && Enumerable.create(Byte.class, Short.class, Integer.class, Long.class).cast(Class.class).contains(rhsClass)) {
            pair.rhs = BigDecimal.valueOf(((Number)pair.rhs).longValue());
        } else if (rhsClass.equals(BigDecimal.class) && Enumerable.create(Byte.class, Short.class, Integer.class, Long.class).cast(Class.class).contains(lhsClass)) {
            pair.lhs = BigDecimal.valueOf(((Number)pair.lhs).longValue());
        } else if (lhsClass.equals(Double.class)) {
            pair.rhs = ((Number)pair.rhs).doubleValue();
        } else if (rhsClass.equals(Double.class)) {
            pair.lhs = ((Number)pair.lhs).doubleValue();
        } else if (lhsClass.equals(Float.class)) {
            pair.rhs = Float.valueOf(((Number)pair.rhs).floatValue());
        } else if (rhsClass.equals(Float.class)) {
            pair.lhs = Float.valueOf(((Number)pair.lhs).floatValue());
        } else if (lhsClass.equals(Long.class)) {
            pair.rhs = ((Number)pair.rhs).longValue();
        } else if (rhsClass.equals(Long.class)) {
            pair.lhs = ((Number)pair.lhs).longValue();
        } else if (lhsClass.equals(Integer.class)) {
            pair.rhs = ((Number)pair.rhs).intValue();
        } else if (rhsClass.equals(Integer.class)) {
            pair.lhs = ((Number)pair.lhs).intValue();
        } else if (lhsClass.equals(Short.class)) {
            pair.rhs = ((Number)pair.rhs).shortValue();
        } else if (rhsClass.equals(Short.class)) {
            pair.lhs = ((Number)pair.lhs).shortValue();
        }
    }

    public static Object cast(Object obj, Class<?> targetType) {
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        if (targetType.isAssignableFrom(objClass)) {
            return obj;
        }
        if (obj instanceof Number && targetType.equals(Double.class)) {
            return (double)((Double)obj);
        }
        if (obj instanceof Number && targetType.equals(Float.class)) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        if (obj instanceof Number && targetType.equals(Long.class)) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Number && targetType.equals(Integer.class)) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Number && targetType.equals(Short.class)) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof Number && targetType.equals(Byte.class)) {
            return ((Number)obj).byteValue();
        }
        if (objClass.equals(Integer.class) && targetType.equals(Integer.TYPE)) {
            return obj;
        }
        throw new UnsupportedOperationException("Unable to cast a " + objClass.getSimpleName() + " to a " + targetType.getSimpleName());
    }

    private class ObjectPair {
        public Object lhs;
        public Object rhs;

        public ObjectPair(CommonExpression lhs, CommonExpression rhs) {
            this(expressionEvaluator.evaluate(lhs), expressionEvaluator.evaluate(rhs));
        }

        public ObjectPair(Object lhs, Object rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    private static interface BinaryFunction {
        public static final BinaryFunction ADD = new BinaryFunction(){

            @Override
            public BigDecimal apply(BigDecimal lhs, BigDecimal rhs) {
                return lhs.add(rhs);
            }

            @Override
            public Double apply(Double lhs, Double rhs) {
                return lhs + rhs;
            }

            @Override
            public Float apply(Float lhs, Float rhs) {
                return Float.valueOf(lhs.floatValue() + rhs.floatValue());
            }

            @Override
            public Integer apply(Integer lhs, Integer rhs) {
                return lhs + rhs;
            }

            @Override
            public Long apply(Long lhs, Long rhs) {
                return lhs + rhs;
            }
        };
        public static final BinaryFunction SUB = new BinaryFunction(){

            @Override
            public BigDecimal apply(BigDecimal lhs, BigDecimal rhs) {
                return lhs.subtract(rhs);
            }

            @Override
            public Double apply(Double lhs, Double rhs) {
                return lhs - rhs;
            }

            @Override
            public Float apply(Float lhs, Float rhs) {
                return Float.valueOf(lhs.floatValue() - rhs.floatValue());
            }

            @Override
            public Integer apply(Integer lhs, Integer rhs) {
                return lhs - rhs;
            }

            @Override
            public Long apply(Long lhs, Long rhs) {
                return lhs - rhs;
            }
        };
        public static final BinaryFunction MUL = new BinaryFunction(){

            @Override
            public BigDecimal apply(BigDecimal lhs, BigDecimal rhs) {
                return lhs.multiply(rhs);
            }

            @Override
            public Double apply(Double lhs, Double rhs) {
                return lhs * rhs;
            }

            @Override
            public Float apply(Float lhs, Float rhs) {
                return Float.valueOf(lhs.floatValue() * rhs.floatValue());
            }

            @Override
            public Integer apply(Integer lhs, Integer rhs) {
                return lhs * rhs;
            }

            @Override
            public Long apply(Long lhs, Long rhs) {
                return lhs * rhs;
            }
        };
        public static final BinaryFunction DIV = new BinaryFunction(){

            @Override
            public BigDecimal apply(BigDecimal lhs, BigDecimal rhs) {
                return lhs.divide(rhs);
            }

            @Override
            public Double apply(Double lhs, Double rhs) {
                return lhs / rhs;
            }

            @Override
            public Float apply(Float lhs, Float rhs) {
                return Float.valueOf(lhs.floatValue() / rhs.floatValue());
            }

            @Override
            public Integer apply(Integer lhs, Integer rhs) {
                return lhs / rhs;
            }

            @Override
            public Long apply(Long lhs, Long rhs) {
                return lhs / rhs;
            }
        };
        public static final BinaryFunction MOD = new BinaryFunction(){

            @Override
            public BigDecimal apply(BigDecimal lhs, BigDecimal rhs) {
                return lhs.remainder(rhs);
            }

            @Override
            public Double apply(Double lhs, Double rhs) {
                return lhs % rhs;
            }

            @Override
            public Float apply(Float lhs, Float rhs) {
                return Float.valueOf(lhs.floatValue() % rhs.floatValue());
            }

            @Override
            public Integer apply(Integer lhs, Integer rhs) {
                return lhs % rhs;
            }

            @Override
            public Long apply(Long lhs, Long rhs) {
                return lhs % rhs;
            }
        };

        public BigDecimal apply(BigDecimal var1, BigDecimal var2);

        public Double apply(Double var1, Double var2);

        public Float apply(Float var1, Float var2);

        public Integer apply(Integer var1, Integer var2);

        public Long apply(Long var1, Long var2);
    }

    public static interface VariableResolver {
        public Object resolveVariable(String var1);
    }
}

