/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import org.odata4j.command.Command;
import org.odata4j.command.CommandResult;
import org.odata4j.producer.command.GetMetadataCommandContext;
import org.odata4j.producer.jdbc.GenerateJdbcModel;
import org.odata4j.producer.jdbc.JdbcMetadataMapping;
import org.odata4j.producer.jdbc.JdbcModel;
import org.odata4j.producer.jdbc.JdbcModelToMetadata;
import org.odata4j.producer.jdbc.JdbcProducerCommandContext;
import org.odata4j.producer.jdbc.LimitJdbcModelToDefaultSchema;

public class JdbcGetMetadataCommand
implements Command<GetMetadataCommandContext> {
    @Override
    public CommandResult execute(GetMetadataCommandContext context) throws Exception {
        JdbcProducerCommandContext jdbcContext = (JdbcProducerCommandContext)((Object)context);
        JdbcModel model = this.generateModel(jdbcContext);
        this.cleanupModel(model);
        JdbcMetadataMapping mapping = this.modelToMapping(jdbcContext, model);
        context.setResult(mapping);
        return CommandResult.CONTINUE;
    }

    public JdbcModel generateModel(JdbcProducerCommandContext jdbcContext) {
        return jdbcContext.getJdbc().execute(new GenerateJdbcModel());
    }

    public void cleanupModel(JdbcModel model) {
        new LimitJdbcModelToDefaultSchema().apply(model);
    }

    public JdbcMetadataMapping modelToMapping(JdbcProducerCommandContext jdbcContext, JdbcModel model) {
        return jdbcContext.get(JdbcModelToMetadata.class).apply(model);
    }
}

