/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.OneToMany;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAMember;
import org.odata4j.producer.jpa.JPAResults;

public class CreateAndLinkCommand
implements Command {
    @Override
    public boolean execute(JPAContext context) {
        List<CascadeType> cascadeTypes;
        EdmNavigationProperty edmNavProperty = context.getEntity().getEdmEntitySet().getType().findNavigationProperty(context.getNavProperty());
        if (edmNavProperty == null || edmNavProperty.getToRole().getMultiplicity() != EdmMultiplicity.MANY) {
            throw new IllegalArgumentException("unknown navigation property " + context.getNavProperty() + " or navigation property toRole Multiplicity is not '*'");
        }
        EntityType<?> newJpaEntityType = context.getOtherEntity().getJPAEntityType();
        Object newJpaEntity = context.getOtherEntity().getJpaEntity();
        final String navProperty = context.getNavProperty();
        PluralAttribute attr = (PluralAttribute)Enumerable.create(context.getEntity().getJPAEntityType().getPluralAttributes()).firstOrNull(new Predicate1(){

            public boolean apply(Object input) {
                PluralAttribute pa = (PluralAttribute)input;
                return pa.getName().equals(navProperty);
            }
        });
        JPAMember member = JPAMember.create(attr, context.getEntity().getJpaEntity());
        Collection collection = (Collection)member.get();
        collection.add(newJpaEntity);
        OneToMany oneToMany = member.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.mappedBy() != null && !oneToMany.mappedBy().isEmpty()) {
            JPAMember.create(newJpaEntityType.getAttribute(oneToMany.mappedBy()), newJpaEntity).set(context.getEntity().getJpaEntity());
        }
        if (oneToMany != null && oneToMany.cascade() != null && !(cascadeTypes = Arrays.asList(oneToMany.cascade())).contains(CascadeType.ALL) && !cascadeTypes.contains(CascadeType.PERSIST)) {
            context.getEntityManager().persist(newJpaEntity);
        }
        context.setResult(JPAResults.entity(context.getOtherEntity().getJpaEntity()));
        return false;
    }
}

