/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.odata4j.core.Throwables;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.ODataProducerFactory;

@Provider
public class DefaultODataProducerProvider
implements ContextResolver<ODataProducer> {
    public static final String FACTORY_PROPNAME = "odata4j.producerfactory";
    private static ODataProducer STATIC;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private ODataProducer instance;

    public static void setInstance(ODataProducer producer) {
        STATIC = producer;
    }

    @Override
    public final ODataProducer getContext(Class<?> type) {
        if (!type.equals(ODataProducer.class)) {
            throw new RuntimeException("Invalid context type");
        }
        if (this.instance != null) {
            return this.instance;
        }
        this.initializeInstance();
        return this.instance;
    }

    private void initializeInstance() {
        this.instance = this.setInstanceToStaticSingleton();
        if (this.instance == null) {
            this.instance = this.createInstanceFromFactoryInContainerSpecificSetting();
        }
        if (this.instance == null) {
            this.instance = this.createInstanceFromFactoryInSystemProperties();
        }
        if (this.instance == null) {
            throw new RuntimeException("Unable to find an OData producer implementation. Call ODataProducerProvider.setInstance to set the static singleton or set the producer factory property 'odata4j.producerfactory' in either the system properties or a container-specifc manner to a class name that implements ODataProducerFactory.");
        }
    }

    private ODataProducer setInstanceToStaticSingleton() {
        if (STATIC != null) {
            this.log("Setting producer instance to static singleton: " + STATIC);
            return STATIC;
        }
        return null;
    }

    protected ODataProducer createInstanceFromFactoryInContainerSpecificSetting() {
        return null;
    }

    private ODataProducer createInstanceFromFactoryInSystemProperties() {
        if (System.getProperty(FACTORY_PROPNAME) != null) {
            String factoryTypeName = System.getProperty(FACTORY_PROPNAME);
            this.log("Creating producer from factory in system properties: " + factoryTypeName);
            return this.newProducerFromFactory(factoryTypeName, System.getProperties());
        }
        return null;
    }

    protected final ODataProducer newProducerFromFactory(String factoryTypeName, Properties props) {
        try {
            Class<?> factoryType = Class.forName(factoryTypeName);
            Object obj = factoryType.newInstance();
            ODataProducerFactory factory = (ODataProducerFactory)obj;
            return factory.create(props);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    protected final void log(String msg) {
        this.log.info(msg);
    }
}

