/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.OError;
import org.odata4j.core.OErrors;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.exceptions.ServerErrorException;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.ErrorResponse;
import org.odata4j.producer.ErrorResponseExtension;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.Responses;

@Provider
public class ExceptionMappingProvider
implements ExceptionMapper<RuntimeException> {
    @Context
    protected ContextResolver<ODataProducer> producerResolver;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders httpHeaders;

    @Override
    public Response toResponse(RuntimeException e) {
        ODataProducerException exception = e instanceof ODataProducerException ? (ODataProducerException)e : new ServerErrorException(e);
        ErrorResponseExtension errorResponseExtension = this.producerResolver.getContext(ODataProducer.class).findExtension(ErrorResponseExtension.class);
        boolean includeInnerError = errorResponseExtension != null && errorResponseExtension.returnInnerError(this.httpHeaders, this.uriInfo, exception);
        FormatWriter<ErrorResponse> fw = FormatWriterFactory.getFormatWriter(ErrorResponse.class, this.httpHeaders.getAcceptableMediaTypes(), this.getFormatParameter(), this.getCallbackParameter());
        StringWriter sw = new StringWriter();
        fw.write(this.uriInfo, sw, ExceptionMappingProvider.getErrorResponse(exception, includeInnerError));
        return Response.status(exception.getHttpStatus()).type(fw.getContentType()).header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).entity(sw.toString()).build();
    }

    public static ErrorResponse getErrorResponse(ODataProducerException exception, boolean includeInnerError) {
        OError error = exception.getOError();
        if (!includeInnerError) {
            error = OErrors.error(error.getCode(), error.getMessage(), null);
        }
        return Responses.error(error);
    }

    private String getFormatParameter() {
        return this.uriInfo.getQueryParameters().getFirst("$format");
    }

    private String getCallbackParameter() {
        return this.uriInfo.getQueryParameters().getFirst("$callback");
    }
}

