/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.odata4j.core.ODataConstants;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.format.FormatType;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.edm.MetadataProducer;
import org.odata4j.producer.resources.EntitiesRequestResource;
import org.odata4j.producer.resources.EntityRequestResource;
import org.odata4j.producer.resources.ServiceDocumentResource;

@Path(value="{first: \\$}metadata")
public class MetadataResource {
    private static final MediaType APPLICATION_ATOMSVC_XML_MEDIATYPE = MediaType.valueOf("application/atomsvc+xml");

    @GET
    @Produces(value={"application/xml;charset=utf-8", "application/atomsvc+xml;charset=utf-8"})
    public Response getMetadata(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @QueryParam(value="$format") String format) {
        ODataProducer source;
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        if ("atomsvc".equals(format) || this.isAtomSvcRequest(httpHeaders)) {
            MetadataProducer metadataProducer = producer.getMetadataProducer();
            if (metadataProducer == null) {
                throw MetadataResource.newMetadataNotImplementedException();
            }
            ServiceDocumentResource r = new ServiceDocumentResource();
            return r.getServiceDocument(httpHeaders, uriInfo, producerResolver, FormatType.ATOM.name(), null);
        }
        StringWriter w = new StringWriter();
        ODataProducer oDataProducer = source = "metamodel".equals(format) ? producer.getMetadataProducer() : producer;
        if (source == null) {
            throw MetadataResource.newMetadataNotImplementedException();
        }
        EdmDataServices s = source.getMetadata();
        EdmxFormatWriter.write(s, w);
        return Response.ok((Object)w.toString(), "application/xml;charset=utf-8").header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    private boolean isAtomSvcRequest(HttpHeaders h) {
        return h.getAcceptableMediaTypes().contains(APPLICATION_ATOMSVC_XML_MEDIATYPE);
    }

    @GET
    @Path(value="{entitySetName}")
    @Produces(value={"application/atom+xml;charset=utf-8", "text/javascript;charset=utf-8", "application/json;charset=utf-8"})
    public Response getMetadataEntities(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="optionalId") String optionalId, @QueryParam(value="$inlinecount") String inlineCount, @QueryParam(value="$top") String top, @QueryParam(value="$skip") String skip, @QueryParam(value="$filter") String filter, @QueryParam(value="$orderby") String orderBy, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @QueryParam(value="$skiptoken") String skipToken, @QueryParam(value="$expand") String expand, @QueryParam(value="$select") String select) throws Exception {
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        MetadataProducer metadataProducer = producer.getMetadataProducer();
        if (metadataProducer == null) {
            throw MetadataResource.newMetadataNotImplementedException();
        }
        EntitiesRequestResource r = new EntitiesRequestResource();
        return r.getEntitiesImpl(httpHeaders, uriInfo, metadataProducer, entitySetName, false, inlineCount, top, skip, filter, orderBy, format, callback, skipToken, expand, select);
    }

    @GET
    @Path(value="{entitySetName}{id: (\\(.+?\\))}")
    @Produces(value={"application/atom+xml;charset=utf-8", "text/javascript;charset=utf-8", "application/json;charset=utf-8"})
    public Response getMetadataEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @QueryParam(value="$expand") String expand, @QueryParam(value="$select") String select) {
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        MetadataProducer metadataProducer = producer.getMetadataProducer();
        if (metadataProducer == null) {
            throw MetadataResource.newMetadataNotImplementedException();
        }
        EntityRequestResource r = new EntityRequestResource();
        return r.getEntityImpl(httpHeaders, uriInfo, metadataProducer, entitySetName, id, format, callback, expand, select);
    }

    private static NotImplementedException newMetadataNotImplementedException() {
        return new NotImplementedException("Queryable metadata not implemented by this producer");
    }
}

