/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.TypeLibLocator;
import com.ibm.cognos.internal.ombridge.TypeLibMetadata;
import com.ibm.cognos.internal.ombridge.logging.Logger;
import com.ibm.cognos.internal.ombridge.schema.BuildNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;

public class FolderLocator
extends TypeLibLocator {
    protected HashMap<String, TypeLibMetadata> metadataMap = new HashMap();
    private static File classesFolder;

    FolderLocator() {
        this(FolderLocator.class.getClassLoader().getResource("ombridge.properties"));
    }

    FolderLocator(URL dirURL) {
        classesFolder = FolderLocator.getClassesFolder(dirURL);
        this.initVersions();
    }

    static File getClassesFolder(URL dirURL) {
        String path = dirURL.getPath();
        File propFile = new File(path);
        if (!propFile.exists()) {
            try {
                path = URLDecoder.decode(path, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            propFile = new File(path);
            if (!propFile.exists()) {
                Logger.BRIDGE.fatal("Unable to locate file: " + path);
                return null;
            }
        }
        if (!(propFile = new File(path).getParentFile()).exists()) {
            Logger.BRIDGE.fatal("Resource folder " + propFile.getAbsolutePath() + " doesn't exists");
            return null;
        }
        return propFile;
    }

    private void initVersions() {
        if (classesFolder != null) {
            classesFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (TypeLibLocator.isTypeLibFile(name).booleanValue()) {
                        String version = TypeLibLocator.extractVersion(name);
                        File file = new File(dir, name);
                        try (FileInputStream fileStream = new FileInputStream(file);){
                            String buildNum = FolderLocator.this.getBuildNumber(fileStream);
                            TypeLibMetadata meta = new TypeLibMetadata(name, new BuildNumber(buildNum));
                            FolderLocator.this.metadataMap.put(version, meta);
                        }
                        catch (Exception e) {
                            System.out.print(e);
                        }
                    }
                    return false;
                }
            });
        }
    }

    @Override
    public Collection<String> getVersions() {
        return this.metadataMap.keySet();
    }

    @Override
    public InputStream getStream(String version) throws FileNotFoundException {
        File typeLibFile = new File(classesFolder, this.metadataMap.get(version).getFileName());
        FileInputStream returnStream = new FileInputStream(typeLibFile);
        return returnStream;
    }

    @Override
    public BuildNumber getBuild(String version) {
        return this.metadataMap.get(version).getBuild();
    }
}

