/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public class NamespaceChanger
extends VisitorSupport {
    private String oldNs;
    private String newNs;

    public NamespaceChanger(String oldNs, String newNs) {
        this.newNs = newNs;
        this.oldNs = oldNs;
    }

    public static void change(Node node, String oldURI, String newURI) {
        node.accept((Visitor)new NamespaceChanger(oldURI, newURI));
    }

    public void visit(Element el) {
        Namespace ns = el.getNamespace();
        if (ns.getURI().equals(this.oldNs)) {
            el.setQName(this.makeName((Node)el, ns));
        }
        for (Namespace tns : el.additionalNamespaces()) {
            if (!tns.getURI().equals(this.oldNs)) continue;
            el.add(Namespace.get((String)tns.getPrefix(), (String)this.newNs));
            el.remove(tns);
        }
    }

    public void visit(Attribute attr) {
        Namespace ns = attr.getNamespace();
        if (ns.getURI().equals(this.oldNs)) {
            attr.getParent().addAttribute(this.makeName((Node)attr, ns), attr.getStringValue());
            attr.detach();
        }
    }

    private QName makeName(Node node, Namespace old) {
        return QName.get((String)node.getName(), (Namespace)Namespace.get((String)old.getPrefix(), (String)this.newNs));
    }
}

