/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.NamespaceChanger;
import com.ibm.cognos.internal.ombridge.schema.ArrayType;
import com.ibm.cognos.internal.ombridge.schema.EnumType;
import com.ibm.cognos.internal.ombridge.schema.PrimitiveType;
import com.ibm.cognos.internal.ombridge.schema.Property;
import com.ibm.cognos.internal.ombridge.schema.Schema;
import com.ibm.cognos.internal.ombridge.schema.StructType;
import com.ibm.cognos.internal.ombridge.schema.Type;
import com.ibm.cognos.internal.ombridge.schema.TypeLibrary;
import com.ibm.cognos.internal.ombridge.schema.XSD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class OMBridge {
    private static final Type UNKNOWN_TYPE = new PrimitiveType("unknown");
    private static final Namespace XSI_NS = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace SOAPENC_NS = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName XSI_TYPE = QName.get((String)"type", (Namespace)XSI_NS);
    private static final QName ARRAY_TYPE = QName.get((String)"arrayType", (Namespace)SOAPENC_NS);
    private static final QName SOAPENC_ARRAY = QName.get((String)"Array", (Namespace)SOAPENC_NS);
    private TypeLibrary dstLib;
    private TypeLibrary srcLib;
    private QName biBusHeader;
    private ArrayList<String[]> nsRemap = null;

    public OMBridge(TypeLibrary src, TypeLibrary dst) {
        this.srcLib = src;
        this.dstLib = dst;
        this.biBusHeader = QName.get((String)"biBusHeader", (String)"bus", (String)this.srcLib.getSchemaByName("bus").getNamespace());
        this.buildNsRemap();
    }

    public TypeLibrary getTargetLibrary() {
        return this.dstLib;
    }

    public TypeLibrary getSourceLibrary() {
        return this.srcLib;
    }

    private void buildNsRemap() {
        for (Schema srcSchema : this.srcLib.schemas()) {
            String dstNS;
            String srcNS;
            Schema dstSchema = this.dstLib.getSchemaByName(srcSchema.getName());
            if (dstSchema == null || (srcNS = srcSchema.getNamespace()).equals(dstNS = dstSchema.getNamespace())) continue;
            if (this.nsRemap == null) {
                this.nsRemap = new ArrayList();
            }
            this.nsRemap.add(new String[]{srcNS, dstNS});
        }
    }

    public void bridge(Document doc) {
        Element root = doc.getRootElement();
        if (!root.getName().equals("Envelope")) {
            return;
        }
        Context ctx = new Context();
        Element header = root.element("Header");
        if (header != null) {
            for (Element el : header.elements()) {
                if (el.getQName().equals((Object)this.biBusHeader)) {
                    Schema sch = this.srcLib.getSchemaByName("bus");
                    this.bridgeElement(el, sch.getType(this.biBusHeader.getName()), ctx);
                    continue;
                }
                this.bridgeElement(el, null, ctx);
            }
        }
        this.bridgeElement(root.element("Body"), null, ctx);
        ctx.cleanUp(this.dstLib);
        this.fixNamespaces(doc);
    }

    private void fixNamespaces(Document doc) {
        if (this.nsRemap != null) {
            for (String[] entry : this.nsRemap) {
                NamespaceChanger.change((Node)doc, entry[0], entry[1]);
            }
        }
    }

    void bridgeElement(Element el, Type srcType, Context ctx) {
        if (el == null) {
            return;
        }
        if (srcType == null && (srcType = this.parseType(el)) == UNKNOWN_TYPE) {
            srcType = null;
        }
        Type dstType = null;
        if (srcType != null) {
            dstType = this.mapType(srcType);
            if (dstType == null) {
                ctx.discard((Node)el);
            } else {
                this.bridgeType(el, srcType, dstType, ctx);
            }
        } else {
            for (Element child : el.elements()) {
                this.bridgeElement(child, null, ctx);
            }
        }
    }

    void bridgeStruct(Element el, StructType srcType, StructType dstType, Context ctx) {
        for (Element child : el.elements()) {
            String name = child.getName();
            Property srcProp = this.getProperty(srcType, name);
            if (srcProp == null) {
                ctx.discard((Node)child);
                continue;
            }
            Property dstProp = this.getProperty(dstType, name);
            if (dstProp == null) {
                ctx.discard((Node)child);
                continue;
            }
            if (srcProp.type().kind() != dstProp.type().kind()) {
                ctx.discard((Node)child);
                continue;
            }
            Type srcPropType = this.getActualPropertyType(child, srcProp);
            if (srcPropType == null) {
                ctx.discard((Node)child);
                continue;
            }
            Type dstPropType = dstProp.type();
            if (srcProp.type() != srcPropType && (dstPropType = this.mapType(srcPropType)) == null) {
                ctx.discard((Node)child);
                continue;
            }
            this.bridgeType(child, srcPropType, dstPropType, ctx);
        }
    }

    private Type getActualPropertyType(Element el, Property prop) {
        Type propType = prop.type();
        if (!propType.hasDerived()) {
            return propType;
        }
        Type actualPropType = this.parseType(el);
        if (actualPropType == UNKNOWN_TYPE) {
            return null;
        }
        if (actualPropType == null) {
            return propType;
        }
        if (actualPropType.isSubclassOf(propType)) {
            return actualPropType;
        }
        return null;
    }

    Property getProperty(StructType t, String name) {
        while (t != null) {
            Property result = t.property(name);
            if (result != null) {
                return result;
            }
            t = (StructType)t.baseType();
        }
        return null;
    }

    void bridgeArray(Element el, ArrayType srcType, ArrayType dstType, Context ctx) {
        Type srcItemType = srcType.itemType();
        Type dstItemType = this.mapType(srcItemType);
        if (dstItemType == null) {
            ctx.discard((Node)el);
            return;
        }
        boolean parseType = srcItemType.hasDerived();
        for (Element child : el.elements()) {
            if (parseType) {
                srcItemType = this.parseType(child);
                if (srcItemType == UNKNOWN_TYPE) {
                    ctx.discard((Node)child);
                    continue;
                }
                if (srcItemType == null) {
                    srcItemType = srcType.itemType();
                }
                dstItemType = this.mapType(srcItemType);
            }
            if (dstItemType == null) {
                ctx.discard((Node)child);
                continue;
            }
            this.bridgeType(child, srcItemType, dstItemType, ctx);
        }
    }

    Type mapType(Type t) {
        Type itemType;
        if (t.schema() == XSD.instance) {
            return t;
        }
        String schemaName = t.schema().getName();
        Schema dstSchema = this.dstLib.getSchemaByName(schemaName);
        if (dstSchema == null) {
            return null;
        }
        Type result = dstSchema.getType(t.name());
        if (result == null && t.kind() == Type.Kind.array && (itemType = this.mapType(((ArrayType)t).itemType())) != null) {
            result = new ArrayType(t.name());
            ((ArrayType)result).setSchema(dstSchema);
            ((ArrayType)result).setItemType(itemType);
        }
        return result;
    }

    void bridgeEnum(Element el, EnumType srcType, EnumType dstType, Context ctx) {
        String value = el.getTextTrim();
        if (!dstType.contains(value)) {
            for (int i = 0; i < ctx.size(); ++i) {
                Context.Entry entry = ctx.top(i);
                if (entry.type.kind() != Type.Kind.array) continue;
                ctx.discard((Node)ctx.top((int)(i - 1)).el);
                return;
            }
            ctx.discard((Node)ctx.top((int)(ctx.size() - 1)).el);
        }
    }

    void bridgeType(Element el, Type srcType, Type dstType, Context ctx) {
        if (srcType.kind() != dstType.kind()) {
            ctx.discard((Node)el);
            return;
        }
        ctx.push(el, dstType);
        switch (dstType.kind()) {
            case array: {
                this.bridgeArray(el, (ArrayType)srcType, (ArrayType)dstType, ctx);
                break;
            }
            case struct: {
                this.bridgeStruct(el, (StructType)srcType, (StructType)dstType, ctx);
                break;
            }
            case enumeration: {
                this.bridgeEnum(el, (EnumType)srcType, (EnumType)dstType, ctx);
                break;
            }
            case primitive: {
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized type: " + (Object)((Object)srcType.kind()));
            }
        }
        ctx.pop();
    }

    Type parseType(Element el) {
        Schema schema;
        String value = el.attributeValue(XSI_TYPE);
        QName typeQName = OMBridge.parseQName(el, value, false);
        if (typeQName == null) {
            return null;
        }
        boolean isArray = false;
        if (typeQName.equals((Object)SOAPENC_ARRAY)) {
            value = el.attributeValue(ARRAY_TYPE);
            typeQName = OMBridge.parseQName(el, value, true);
            if (typeQName == null) {
                return null;
            }
            isArray = true;
        }
        if ((schema = this.srcLib.getSchemaByNamespace(typeQName.getNamespaceURI())) == null) {
            return null;
        }
        String typeName = typeQName.getName();
        Type result = null;
        if (isArray) {
            result = schema.getType(typeName + "Array");
            if (result != null) {
                return result;
            }
            result = schema.getType(typeName);
            if (result != null) {
                ArrayType atype = new ArrayType(typeName + "Array");
                atype.setSchema(schema);
                atype.setItemType(result);
                return atype;
            }
        } else {
            result = schema.getType(typeName);
        }
        return result == null ? UNKNOWN_TYPE : result;
    }

    static QName parseQName(Element context, String s, boolean isArray) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int separator = s.indexOf(58);
        if (separator == -1) {
            return null;
        }
        String prefix = s.substring(0, separator);
        s = s.substring(separator + 1);
        Namespace ns = context.getNamespaceForPrefix(prefix);
        if (ns == null) {
            return null;
        }
        if (isArray) {
            separator = s.indexOf(91);
            if (separator == -1) {
                return null;
            }
            s = s.substring(0, separator);
        }
        return QName.get((String)s, (Namespace)ns);
    }

    static class Context {
        private Collection<Node> discard = new HashSet<Node>();
        private ArrayList<Entry> stack = new ArrayList();
        private int size = 0;

        Context() {
        }

        public void cleanUp(TypeLibrary dstLib) {
            for (Node node : this.discard) {
                node.detach();
            }
        }

        public void push(Element el, Type dstType) {
            if (this.size == this.stack.size()) {
                this.stack.add(new Entry());
            }
            Entry entry = this.stack.get(this.size);
            entry.el = el;
            entry.type = dstType;
            ++this.size;
        }

        public Entry pop() {
            if (this.size == 0) {
                throw new IllegalStateException("Stcak underflow");
            }
            --this.size;
            return this.stack.get(this.size);
        }

        public Entry top(int offset) {
            return this.stack.get(this.size - (offset + 1));
        }

        public int size() {
            return this.size;
        }

        public void discard(Node n) {
            this.discard.add(n);
        }

        static class Entry {
            public Element el;
            public Type type;

            Entry() {
            }
        }
    }
}

