/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.Signer;
import com.ibm.cognos.internal.ombridge.SignerFactory;
import com.ibm.cognos.internal.ombridge.schema.TypeLibrary;
import com.ibm.cognos.internal.ombridge.schema.UserCapabilityBitEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class UserCapabilityCache {
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName SOAPHeader = QName.get((String)"Header", (Namespace)NS_SOAP_ENV);
    private static final String CAPABILITY_COOKIEPARM_DELIMITER = "%26";
    private static final String CAPABILITY_DELIMITER = "%3B";
    private static Signer signer = SignerFactory.createSigner();
    private byte[] capabilityData = null;
    private TypeLibrary dstTypeLib;

    public UserCapabilityCache(TypeLibrary dst) {
        this.dstTypeLib = dst;
    }

    public void verify(Document soapEnv, String passport) {
        Element ucCache = this.getUserCapabilityCache(soapEnv);
        if (ucCache == null) {
            return;
        }
        byte[] signature = this.getSignature(ucCache);
        ArrayList<String> capabilities = this.getUserCapabilities(ucCache);
        byte[] data = this.getCapabilityBytes(capabilities);
        if (signature == null || data == null) {
            return;
        }
        if (signer.verifyTrustToken(data, signature, passport)) {
            this.capabilityData = data;
        }
    }

    public void sign(Document soapEnv, String passport) {
        if (this.capabilityData == null) {
            return;
        }
        Element ucCache = this.getUserCapabilityCache(soapEnv);
        if (ucCache == null) {
            return;
        }
        ArrayList<String> capabilities = this.getUserCapabilities(ucCache);
        byte[] data = this.getCapabilityBytes(capabilities);
        if (data == null || Arrays.equals(this.capabilityData, data)) {
            return;
        }
        byte[] bytes = signer.createTrustToken(data, passport);
        if (bytes == null) {
            return;
        }
        String signature = new String(bytes);
        ucCache.element("signature").setText(signature);
        this.updateCapabilityCookie(ucCache, capabilities, signature);
    }

    private void updateCapabilityCookie(Element ucCache, ArrayList<String> capabilities, String signature) {
        Element el = this.getCookieValueElement(ucCache);
        if (el == null) {
            return;
        }
        UserCapabilityBitEncoder encoder = this.dstTypeLib.getUserCapabilityBitEncoder();
        StringBuilder buf = new StringBuilder();
        buf.append(encoder.encode(capabilities, CAPABILITY_DELIMITER));
        buf.append(CAPABILITY_COOKIEPARM_DELIMITER);
        try {
            buf.append(URLEncoder.encode(signature, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        el.setText(buf.toString());
    }

    private Element getCookieValueElement(Element ucCache) {
        try {
            Element el = ucCache.getParent().element("hdrSession").element("setCookieVars");
            if (el == null) {
                return null;
            }
            for (Element var : el.elements()) {
                if (!"userCapabilities".equals(var.elementText("name"))) continue;
                return var.element("value");
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private Element getUserCapabilityCache(Document soapEnv) {
        Element el = soapEnv.getRootElement();
        try {
            return el.element(SOAPHeader).element("biBusHeader").element("userCapabilityCache");
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    private byte[] getSignature(Element ucCache) {
        Element el = ucCache.element("signature");
        if (el == null) {
            return null;
        }
        String signature = el.getText();
        return signature.getBytes();
    }

    private ArrayList<String> getUserCapabilities(Element el) {
        if ((el = el.element("userCapabilities")) == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element item : el.elements()) {
            result.add(item.getText());
        }
        return result;
    }

    private byte[] getCapabilityBytes(ArrayList<String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<userCapabilities>");
        for (String s : strings) {
            buf.append("<item>");
            buf.append(s);
            buf.append("</item>");
        }
        buf.append("</userCapabilities>");
        return buf.toString().getBytes();
    }
}

