/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.schema;

import com.ibm.cognos.internal.ombridge.schema.BuildNumber;
import com.ibm.cognos.internal.ombridge.schema.Schema;
import com.ibm.cognos.internal.ombridge.schema.UserCapabilityBitEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeLibrary {
    private HashMap<String, Schema> byName = new HashMap();
    private HashMap<String, Schema> byNamespace = new HashMap();
    private String version;
    private BuildNumber build;
    private Map<String, Integer> mapCapabilities;
    private Set<String> setPassthrough;
    private UserCapabilityBitEncoder capabilityEncoder;

    public TypeLibrary(String version, String build) {
        this.version = version;
        this.build = new BuildNumber(build);
        this.mapCapabilities = new HashMap<String, Integer>();
        this.setPassthrough = new HashSet<String>();
        this.capabilityEncoder = new UserCapabilityBitEncoder();
    }

    public String getVersion() {
        return this.version;
    }

    public BuildNumber getBuildNumber() {
        return this.build;
    }

    public void addSchema(Schema schema) {
        String name = schema.getName();
        String ns = schema.getNamespace();
        if (this.byName.containsKey(name)) {
            throw new IllegalStateException("Duplicate schema name: " + name);
        }
        if (this.byNamespace.containsKey(ns)) {
            throw new IllegalStateException("Duplicate schema URI: " + ns);
        }
        this.byName.put(name, schema);
        this.byNamespace.put(ns, schema);
    }

    public Schema getSchemaByName(String name) {
        return this.byName.get(name);
    }

    public Schema getSchemaByNamespace(String ns) {
        return this.byNamespace.get(ns);
    }

    public Collection<Schema> schemas() {
        return this.byName.values();
    }

    public Map<String, Integer> getCapabilities() {
        return this.mapCapabilities;
    }

    public Set<String> getPassthrough() {
        return this.setPassthrough;
    }

    public int getMaxBitIndex() {
        return this.capabilityEncoder.getMaxBitIndex();
    }

    public UserCapabilityBitEncoder getUserCapabilityBitEncoder() {
        return this.capabilityEncoder;
    }
}

