/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.AdditionalServiceParameter;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.AttributeMap;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log.Priority;

public class AdditionalServices {
    private static final PogoLogger log = PogoLogger.getLogger();
    private HashMap<String, String> dispatcherPathCache = new HashMap();

    protected MBeanServerConnection getMBeanServer() {
        return PogoMBeanServer.getInstance().getProxyMBeanServer();
    }

    public void addToDispatcherList(DispatcherList dispatcherList) {
        Iterator<DispatcherListElement> iterator = dispatcherList.getAllDispatcherListElements();
        while (iterator.hasNext()) {
            DispatcherListElement dle = iterator.next();
            NodeID nodeID = dle.getNodeID();
            log.debug("addToDispatcherList - call addServicesForDispatcher: nodeid=", nodeID, ", dispatcher name = ", dle.toString());
            this.addServicesForDispatcher(dle.toString(), dispatcherList);
        }
    }

    public void addServicesForDispatcher(String dispatcherName, DispatcherList dispatcherList) {
        Collection<AdditionalServiceParameter> parametersForDispatcher = this.getParametersForDispatcher(dispatcherName);
        log.debug("parametersForDispatcher - size: ", parametersForDispatcher.size());
        this.addParametersToDispatcherList(parametersForDispatcher, dispatcherList);
    }

    protected Collection<AdditionalServiceParameter> getParametersForDispatcher(String dispatcherName) {
        try {
            return this.getParametersForObjectName(MBeanUtils.getDispatcherObjectName(dispatcherName, "ServiceOperationalStatus"), dispatcherName);
        }
        catch (Exception e) {
            log.warn("Exception getting remote service availability for dispatcher " + dispatcherName, e);
            return Collections.emptyList();
        }
    }

    private Collection<AdditionalServiceParameter> getParametersForObjectName(ObjectName objectName, String dispatcherName) throws Exception {
        String[] operationalStatusAttributes = this.getOperationalStatusAttributes(objectName);
        AttributeList attributes = this.getMBeanServer().getAttributes(objectName, operationalStatusAttributes);
        return this.createAvailableParameters(dispatcherName, operationalStatusAttributes, attributes);
    }

    Collection<AdditionalServiceParameter> createAvailableParameters(String dispatcherName, String[] operationalStatusAttributes, AttributeList attributes) throws IOException {
        log.debug("createAvailableParameters - start - dispName: ", dispatcherName);
        HashSet<AdditionalServiceParameter> availableParameters = new HashSet<AdditionalServiceParameter>();
        AttributeMap attributeMap = new AttributeMap(attributes);
        for (int i = 0; i < operationalStatusAttributes.length; ++i) {
            String availability = attributeMap.get(operationalStatusAttributes[i]);
            if (availability != null && availability.equals(ServiceStatus.AVAILABLE)) {
                AdditionalServiceParameter parameter = this.createParameter(dispatcherName, operationalStatusAttributes[i], availability);
                if (parameter != null) {
                    availableParameters.add(parameter);
                    continue;
                }
                log.debug("createAvailableParameters - DispatcherSearchPath return null");
                continue;
            }
            log.debug("createAvailableParameters - operationalStatusAttributes[", i, "]: ", operationalStatusAttributes[i], ", availability: NOT AVAILABLE");
        }
        return availableParameters;
    }

    private AdditionalServiceParameter createParameter(String dispatcherName, String serviceName, String availability) throws IOException {
        if (dispatcherName == null) {
            StringTokenizer tokenizer = new StringTokenizer(serviceName, ",");
            dispatcherName = tokenizer.nextToken();
            serviceName = tokenizer.nextToken();
        }
        String path = this.getPathForDispatcher(dispatcherName);
        String running = availability.equalsIgnoreCase("available") ? "running" : "stopped";
        return path == null ? null : new AdditionalServiceParameter(serviceName, running, path);
    }

    String getPathForDispatcher(String dispatcherName) throws IOException {
        String path = this.dispatcherPathCache.get(dispatcherName);
        if (path == null) {
            path = this.lookupDispatcherPath(dispatcherName);
            this.dispatcherPathCache.put(dispatcherName, path);
        }
        return path;
    }

    private String lookupDispatcherPath(String dispatcherName) throws IOException {
        try {
            ObjectName dispatcherObjectName = MBeanUtils.getDispatcherObjectName(dispatcherName, "Metrics");
            return (String)this.getMBeanServer().getAttribute(dispatcherObjectName, "DispatcherSearchPath");
        }
        catch (JMException e) {
            log.warn("Exception getting dispatcher search path ", e);
            return null;
        }
    }

    String[] getOperationalStatusAttributes(ObjectName objectName) throws Exception {
        MBeanInfo beanInfo = this.getMBeanServer().getMBeanInfo(objectName);
        MBeanAttributeInfo[] attributeInfo = beanInfo.getAttributes();
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < attributeInfo.length; ++i) {
            MBeanAttributeInfo info = attributeInfo[i];
            String attributeName = info.getName();
            if (attributeName.contains("OperationalStatus")) continue;
            attributes.add(attributeName);
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    private void addParametersToDispatcherList(Collection<AdditionalServiceParameter> set, DispatcherList dispatcherList) {
        for (AdditionalServiceParameter additionalServiceParameter : set) {
            dispatcherList.addServiceToDispatcherList(additionalServiceParameter);
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

