/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.ConnectionTracker;
import com.cognos.p2plb.clerver.ConnectionTrackerFactory;
import com.cognos.p2plb.clerver.ConnectionTrackers;
import com.cognos.p2plb.clerver.LoadBalanceConnectionTrackerFactory;
import com.cognos.p2plb.clerver.SocketFactory;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import com.cognos.pogo.util.timer.PogoTimeoutController;
import java.io.IOException;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.util.TimeoutController;
import org.dom4j.Element;

public class ConnectionPoolMap {
    static PogoLogger log = PogoLogger.getLogger();
    static final int DEFAULT_PING_INTERVAL = 30000;
    static final int DEFAULT_REQUEST_TIMEOUT = 30000;
    private long pingInterval = 30000L;
    private int requestTimeout = 30000;
    private ConnectionTrackers connectionTrackers;
    private PogoTimeoutController timeoutController;
    private SocketFactory socketFactory;
    private Timer timer;

    public static void setLoggerForTesting(PogoLogger log) {
        ConnectionPoolMap.log = log;
    }

    public ConnectionPoolMap() {
        this(new LoadBalanceConnectionTrackerFactory(), new PogoTimeoutController(), new SocketFactory(), new Timer(true));
    }

    public ConnectionPoolMap(ConnectionTrackerFactory connectionTrackerFactory, PogoTimeoutController timeoutController, SocketFactory socketFactory, Timer timer) {
        this.connectionTrackers = new ConnectionTrackers(this, connectionTrackerFactory);
        this.timeoutController = timeoutController;
        this.socketFactory = socketFactory;
        this.timer = timer;
    }

    public void configure(Element config) {
        Element eCC = config.element("connectionChecking");
        if (eCC == null) {
            log.error("connectionChecking configuration is missing, will use hard coded defaults.");
        } else {
            try {
                this.pingInterval = Integer.parseInt(eCC.elementText("cc_ping_interval_ms"));
                this.requestTimeout = Integer.parseInt(eCC.elementText("cc_request_timeout_ms"));
                int timeoutChecks = Integer.parseInt(eCC.elementText("cc_timeout_checks"));
                this.connectionTrackers.setTimeoutChecks(timeoutChecks);
            }
            catch (Exception x) {
                log.error("Invalid or missing connectionChecking parameter value.");
            }
        }
    }

    public ServerConnection getConnection(NodeID nid) {
        ConnectionTracker pool = this.connectionTrackers.getConnectionTracker(nid);
        ServerConnection connection = pool.getConnection();
        this.conditionConnection(connection);
        return connection;
    }

    private void conditionConnection(ServerConnection connection) {
        connection.changeTimeout(this.requestTimeout);
        connection.setConnectionTimeout(this.requestTimeout);
    }

    public void startTimer() {
        this.timer.schedule((TimerTask)new PingTask(), this.pingInterval, this.pingInterval);
    }

    public void destroy() {
        this.stopTimer();
        this.destroyPools();
    }

    private void destroyPools() {
        this.connectionTrackers.destroy();
    }

    private void stopTimer() {
        this.timer.cancel();
    }

    public boolean checkConnection(NodeID nodeID) {
        return this.connectionTrackers.isReachable(nodeID);
    }

    public int getPoolUseSize(NodeID nodeID) {
        return this.connectionTrackers.getPoolSize(nodeID);
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getTimeoutChecks() {
        return this.connectionTrackers.getTimeoutChecks();
    }

    public class PingThread
    implements Runnable {
        private final NodeID nodeID;
        private Exception exception;

        public PingThread(NodeID nodeID) {
            this.nodeID = nodeID;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                Socket socket = ConnectionPoolMap.this.socketFactory.createSocket(this.nodeID.getHost(), this.nodeID.getPort());
                socket.close();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }

    public class PingTask
    extends SafeTimerTask {
        @Override
        public void safeRun() {
            for (NodeID nodeID : ConnectionPoolMap.this.connectionTrackers.getActiveNodes()) {
                this.checkNode(nodeID);
            }
        }

        private void checkNode(NodeID nodeID) {
            try {
                PingThread pingThread = new PingThread(nodeID);
                ConnectionPoolMap.this.timeoutController.execute(pingThread, ConnectionPoolMap.this.pingInterval);
                if (pingThread.getException() != null) {
                    log.debug("Failed ping on node: ", nodeID);
                    ConnectionPoolMap.this.connectionTrackers.markAsUnreachable(nodeID);
                    return;
                }
            }
            catch (TimeoutController.TimeoutException e) {
                log.debug("Ping timeout on node: ", nodeID);
                ConnectionPoolMap.this.connectionTrackers.markAsUnreachable(nodeID);
                return;
            }
            log.debug("Ping succeeded on node: ", nodeID);
            ConnectionPoolMap.this.connectionTrackers.markAsReachable(nodeID);
        }
    }
}

