/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.pogo.bibus.BIBusPassThroughCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.InternetHeaders;

public class LBForwardingPassThroughCommand
extends BIBusPassThroughCommand {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ServerConnection connection;
    private String uriPath;

    public LBForwardingPassThroughCommand(BIBusEnvelope envelope, MessageContext mc, ServerConnection connection, String uriPath) {
        super(envelope, LBForwardingPassThroughCommand.getRequestHeaders(mc), mc);
        this.connection = connection;
        this.uriPath = this.encodePath(uriPath);
        this.setAutoRelease(false);
    }

    private String encodePath(String path) {
        if (path != null) {
            try {
                path = URLEncoderDecoder.encode(path, "UTF-8", false, false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return path;
    }

    private static InternetHeaders getRequestHeaders(MessageContext mc) {
        return (InternetHeaders)mc.getProperty("request.headers");
    }

    @Override
    protected String fetchRequestContext() {
        return this.uriPath;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return this.connection;
    }

    public boolean supportsResponseEnvelope() {
        return true;
    }

    @Override
    protected void processResponseBody() throws CommandExecutionException {
    }

    public void updateRequestForTesting() throws CommandExecutionException {
        this.updateRequest();
    }
}

