/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogResourceCounterSet;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.Version;

public class PerfIndicationHelper {
    private MessageContext mc;
    private LogResourceCounterSet ctrset;
    private LogPerfIndication pind;

    public PerfIndicationHelper(MessageContext mc, int level, String name, String method) {
        this.mc = mc;
        this.ctrset = new LogResourceCounterSet("elapsed", null);
        this.pind = new LogPerfIndication("DISP", Version.getVersion(), this.ctrset);
        this.pind.setLevel(level);
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String requestID = env.getRequestContext();
        this.pind.setRequestID(requestID);
        this.pind.setClassId(name);
        this.pind.setMethodId(method);
        this.insertPassportId();
    }

    public void start(LogTypedLogger logger) {
        this.ctrset.enableResourceCounter();
        this.pind.setStatus("ENTER");
        logger.log((Object)this.pind);
    }

    public void stop(LogTypedLogger logger, String logData) {
        this.ctrset.disableResourceCounter();
        if (logData != null) {
            this.pind.setLogData(logData);
        }
        this.pind.setStatus("EXIT");
        logger.log((Object)this.pind);
    }

    private void insertPassportId() {
        String passportid = (String)this.mc.getProperty("auth.passportid");
        this.pind.setSessionID(passportid);
    }

    String getPerfIndicationRequestID() {
        return this.pind.getRequestID();
    }
}

